/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.RowComparator;
import org.apache.flink.api.java.typeutils.runtime.RowSerializer;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class RowTypeInfo
extends TupleTypeInfoBase<Row> {
    private static final long serialVersionUID = 9158518989896601963L;
    private static final String REGEX_INT_FIELD = "[0-9]+";
    private static final String REGEX_STR_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*";
    private static final String REGEX_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+";
    private static final String REGEX_NESTED_FIELDS = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?");
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?|\\*|\\_");
    private static final Pattern PATTERN_INT_FIELD = Pattern.compile("[0-9]+");
    protected final String[] fieldNames;
    private boolean[] comparatorOrders = null;

    public RowTypeInfo(TypeInformation<?> ... types) {
        super(Row.class, types);
        this.fieldNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.fieldNames[i] = "f" + i;
        }
    }

    public RowTypeInfo(TypeInformation<?>[] types, String[] fieldNames) {
        super(Row.class, types);
        Preconditions.checkNotNull(fieldNames, "FieldNames should not be null.");
        Preconditions.checkArgument(types.length == fieldNames.length, "Number of field types and names is different.");
        Preconditions.checkArgument(!this.hasDuplicateFieldNames(fieldNames), "Field names are not unique.");
        this.fieldNames = Arrays.copyOf(fieldNames, fieldNames.length);
    }

    @Override
    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid tuple field reference \"" + fieldExpression + "\".");
        }
        String field = matcher.group(0);
        if (field.equals("*") || field.equals("_")) {
            int keyPosition = 0;
            for (TypeInformation fType : this.types) {
                if (fType instanceof CompositeType) {
                    CompositeType cType = (CompositeType)fType;
                    cType.getFlatFields("*", offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition, fType));
                }
                ++keyPosition;
            }
        } else {
            field = matcher.group(1);
            Matcher intFieldMatcher = PATTERN_INT_FIELD.matcher(field);
            int fieldIndex = intFieldMatcher.matches() ? Integer.valueOf(field).intValue() : this.getFieldIndex(field);
            TypeInformation fieldType = this.getTypeAt(fieldIndex);
            for (int i = 0; i < fieldIndex; ++i) {
                offset += this.getTypeAt(i).getTotalFields();
            }
            String tail = matcher.group(3);
            if (tail == null) {
                if (fieldType instanceof CompositeType) {
                    ((CompositeType)fieldType).getFlatFields("*", offset, result);
                } else {
                    result.add(new CompositeType.FlatFieldDescriptor(offset, fieldType));
                }
            } else if (fieldType instanceof CompositeType) {
                ((CompositeType)fieldType).getFlatFields(tail, offset, result);
            } else {
                throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
            }
        }
    }

    @Override
    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of Row field expression \"" + fieldExpression + "\".");
        }
        String field = matcher.group(1);
        Matcher intFieldMatcher = PATTERN_INT_FIELD.matcher(field);
        int fieldIndex = intFieldMatcher.matches() ? Integer.valueOf(field).intValue() : this.getFieldIndex(field);
        TypeInformation fieldType = this.getTypeAt(fieldIndex);
        String tail = matcher.group(3);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    @Override
    public TypeComparator<Row> createComparator(int[] logicalKeyFields, boolean[] orders, int logicalFieldOffset, ExecutionConfig config) {
        this.comparatorOrders = orders;
        TypeComparator<Row> comparator = super.createComparator(logicalKeyFields, orders, logicalFieldOffset, config);
        this.comparatorOrders = null;
        return comparator;
    }

    @Override
    protected CompositeType.TypeComparatorBuilder<Row> createTypeComparatorBuilder() {
        if (this.comparatorOrders == null) {
            throw new IllegalStateException("Cannot create comparator builder without orders.");
        }
        return new RowTypeComparatorBuilder(this.comparatorOrders);
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TypeSerializer<Row> createSerializer(ExecutionConfig config) {
        int len = this.getArity();
        TypeSerializer[] fieldSerializers = new TypeSerializer[len];
        for (int i = 0; i < len; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer(config);
        }
        return new RowSerializer(fieldSerializers);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof RowTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.fieldNames);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("Row");
        if (this.types.length > 0) {
            bld.append('(').append(this.fieldNames[0]).append(": ").append(this.types[0]);
            for (int i = 1; i < this.types.length; ++i) {
                bld.append(", ").append(this.fieldNames[i]).append(": ").append(this.types[i]);
            }
            bld.append(')');
        }
        return bld.toString();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.types;
    }

    public boolean schemaEquals(Object obj) {
        return this.equals(obj) && Arrays.equals(this.fieldNames, ((RowTypeInfo)obj).fieldNames);
    }

    private boolean hasDuplicateFieldNames(String[] fieldNames) {
        HashSet<String> names = new HashSet<String>();
        for (String field : fieldNames) {
            if (names.add(field)) continue;
            return true;
        }
        return false;
    }

    public static RowTypeInfo projectFields(RowTypeInfo rowType, int[] fieldMapping) {
        TypeInformation[] fieldTypes = new TypeInformation[fieldMapping.length];
        String[] fieldNames = new String[fieldMapping.length];
        for (int i = 0; i < fieldMapping.length; ++i) {
            fieldTypes[i] = rowType.getTypeAt(fieldMapping[i]);
            fieldNames[i] = rowType.getFieldNames()[fieldMapping[i]];
        }
        return new RowTypeInfo(fieldTypes, fieldNames);
    }

    private class RowTypeComparatorBuilder
    implements CompositeType.TypeComparatorBuilder<Row> {
        private final ArrayList<TypeComparator> fieldComparators = new ArrayList();
        private final ArrayList<Integer> logicalKeyFields = new ArrayList();
        private final boolean[] comparatorOrders;

        public RowTypeComparatorBuilder(boolean[] comparatorOrders) {
            this.comparatorOrders = comparatorOrders;
        }

        @Override
        public void initializeTypeComparatorBuilder(int size) {
            this.fieldComparators.ensureCapacity(size);
            this.logicalKeyFields.ensureCapacity(size);
        }

        @Override
        public void addComparatorField(int fieldId, TypeComparator<?> comparator) {
            this.fieldComparators.add(comparator);
            this.logicalKeyFields.add(fieldId);
        }

        @Override
        public TypeComparator<Row> createTypeComparator(ExecutionConfig config) {
            Preconditions.checkState(this.fieldComparators.size() > 0, "No field comparators were defined for the TupleTypeComparatorBuilder.");
            Preconditions.checkState(this.logicalKeyFields.size() > 0, "No key fields were defined for the TupleTypeComparatorBuilder.");
            Preconditions.checkState(this.fieldComparators.size() == this.logicalKeyFields.size(), "The number of field comparators and key fields is not equal.");
            int maxKey = Collections.max(this.logicalKeyFields);
            Preconditions.checkState(maxKey >= 0, "The maximum key field must be greater or equal than 0.");
            TypeSerializer[] fieldSerializers = new TypeSerializer[maxKey + 1];
            for (int i = 0; i <= maxKey; ++i) {
                fieldSerializers[i] = RowTypeInfo.this.types[i].createSerializer(config);
            }
            int[] keyPositions = new int[this.logicalKeyFields.size()];
            for (int i = 0; i < keyPositions.length; ++i) {
                keyPositions[i] = this.logicalKeyFields.get(i);
            }
            TypeComparator[] comparators = new TypeComparator[this.fieldComparators.size()];
            for (int i = 0; i < this.fieldComparators.size(); ++i) {
                comparators[i] = this.fieldComparators.get(i);
            }
            return new RowComparator(RowTypeInfo.this.getArity(), keyPositions, comparators, fieldSerializers, this.comparatorOrders);
        }
    }
}

