/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.NullMaskUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowSerializer
extends TypeSerializer<Row> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    private transient boolean[] nullMask;

    public RowSerializer(TypeSerializer<?>[] fieldSerializers) {
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
        this.nullMask = new boolean[fieldSerializers.length];
    }

    public TypeSerializer<?>[] getFieldSerializers() {
        return this.fieldSerializers;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Row> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowSerializer(duplicateFieldSerializers);
    }

    @Override
    public Row createInstance() {
        return new Row(this.fieldSerializers.length);
    }

    @Override
    public Row copy(Row from) {
        int len = this.fieldSerializers.length;
        if (from.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        Row result = new Row(len);
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy = this.fieldSerializers[i].copy(fromField);
                result.setField(i, copy);
                continue;
            }
            result.setField(i, null);
        }
        return result;
    }

    @Override
    public Row copy(Row from, Row reuse) {
        int len = this.fieldSerializers.length;
        if (reuse == null) {
            return this.copy(from);
        }
        if (from.getArity() != len || reuse.getArity() != len) {
            throw new RuntimeException("Row arity of reuse or from is incompatible with this RowSerializer.");
        }
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy;
                Object reuseField = reuse.getField(i);
                if (reuseField != null) {
                    copy = this.fieldSerializers[i].copy(fromField, reuseField);
                    reuse.setField(i, copy);
                    continue;
                }
                copy = this.fieldSerializers[i].copy(fromField);
                reuse.setField(i, copy);
                continue;
            }
            reuse.setField(i, null);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void serialize(Row record, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        if (record.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        NullMaskUtils.writeNullMask(len, record, target);
        for (int i = 0; i < len; ++i) {
            Object o = record.getField(i);
            if (o == null) continue;
            this.fieldSerializers[i].serialize(o, target);
        }
    }

    @Override
    public Row deserialize(DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        Row result = new Row(len);
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                result.setField(i, null);
                continue;
            }
            result.setField(i, this.fieldSerializers[i].deserialize(source));
        }
        return result;
    }

    @Override
    public Row deserialize(Row reuse, DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        if (reuse.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                reuse.setField(i, null);
                continue;
            }
            Object reuseField = reuse.getField(i);
            if (reuseField != null) {
                reuse.setField(i, this.fieldSerializers[i].deserialize(reuseField, source));
                continue;
            }
            reuse.setField(i, this.fieldSerializers[i].deserialize(source));
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        NullMaskUtils.readIntoAndCopyNullMask(len, source, target, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) continue;
            this.fieldSerializers[i].copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            RowSerializer other = (RowSerializer)obj;
            if (this.fieldSerializers.length == other.fieldSerializers.length) {
                for (int i = 0; i < this.fieldSerializers.length; ++i) {
                    if (this.fieldSerializers[i].equals(other.fieldSerializers[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof RowSerializer;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fieldSerializers);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.nullMask = new boolean[this.fieldSerializers.length];
    }

    @Override
    public RowSerializerConfigSnapshot snapshotConfiguration() {
        return new RowSerializerConfigSnapshot((TypeSerializer[])this.fieldSerializers);
    }

    @Override
    public CompatibilityResult<Row> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousFieldSerializersAndConfigs;
        if (configSnapshot instanceof RowSerializerConfigSnapshot && (previousFieldSerializersAndConfigs = ((RowSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs()).size() == this.fieldSerializers.length) {
            boolean requireMigration = false;
            TypeSerializer[] convertDeserializers = new TypeSerializer[this.fieldSerializers.length];
            int i = 0;
            for (Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot> f : previousFieldSerializersAndConfigs) {
                CompatibilityResult<Object> compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)f.f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)f.f1, this.fieldSerializers[i]);
                if (compatResult.isRequiresMigration()) {
                    requireMigration = true;
                    if (compatResult.getConvertDeserializer() == null) {
                        return CompatibilityResult.requiresMigration();
                    }
                    convertDeserializers[i] = new TypeDeserializerAdapter<Object>(compatResult.getConvertDeserializer());
                }
                ++i;
            }
            if (requireMigration) {
                return CompatibilityResult.requiresMigration(new RowSerializer(convertDeserializers));
            }
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer[] fieldSerializers) {
            super(fieldSerializers);
        }

        @Override
        public int getVersion() {
            return 1;
        }
    }
}

