/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class TupleSerializerConfigSnapshot<T>
extends CompositeTypeSerializerConfigSnapshot {
    private static final int VERSION = 1;
    private Class<T> tupleClass;

    public TupleSerializerConfigSnapshot() {
    }

    public TupleSerializerConfigSnapshot(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        super(fieldSerializers);
        this.tupleClass = Preconditions.checkNotNull(tupleClass);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(out);){
            InstantiationUtil.serializeObject(outViewWrapper, this.tupleClass);
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
            this.tupleClass = (Class)InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader(), true);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find requested tuple class in classpath.", e);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public Class<T> getTupleClass() {
        return this.tupleClass;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof TupleSerializerConfigSnapshot && this.tupleClass.equals(((TupleSerializerConfigSnapshot)obj).getTupleClass());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.tupleClass.hashCode();
    }
}

