/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class BlobServerOptions {
    public static final ConfigOption<String> STORAGE_DIRECTORY = ConfigOptions.key("blob.storage.directory").noDefaultValue().withDescription("The config parameter defining the storage directory to be used by the blob server.");
    public static final ConfigOption<Integer> FETCH_RETRIES = ConfigOptions.key("blob.fetch.retries").defaultValue(5).withDescription("The config parameter defining number of retires for failed BLOB fetches.");
    public static final ConfigOption<Integer> FETCH_CONCURRENT = ConfigOptions.key("blob.fetch.num-concurrent").defaultValue(50).withDescription("The config parameter defining the maximum number of concurrent BLOB fetches that the JobManager serves.");
    public static final ConfigOption<Integer> FETCH_BACKLOG = ConfigOptions.key("blob.fetch.backlog").defaultValue(1000).withDescription("The config parameter defining the backlog of BLOB fetches on the JobManager.");
    public static final ConfigOption<String> PORT = ConfigOptions.key("blob.server.port").defaultValue("0").withDescription("The config parameter defining the server port of the blob service.");
    public static final ConfigOption<Boolean> SSL_ENABLED = ConfigOptions.key("blob.service.ssl.enabled").defaultValue(true).withDescription("Flag to override ssl support for the blob service transport.");
    public static final ConfigOption<Long> CLEANUP_INTERVAL = ConfigOptions.key("blob.service.cleanup.interval").defaultValue(3600L).withDeprecatedKeys("library-cache-manager.cleanup.interval").withDescription("Cleanup interval of the blob caches at the task managers (in seconds).");
    public static final ConfigOption<Integer> OFFLOAD_MINSIZE = ConfigOptions.key("blob.offload.minsize").defaultValue(0x100000).withDescription("The minimum size for messages to be offloaded to the BlobServer.");
}

