/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;

public class ConfigurationUtils {
    private static final String[] EMPTY = new String[0];

    @Nonnull
    public static String[] parseTempDirectories(Configuration configuration) {
        return ConfigurationUtils.splitPaths(configuration.getString(CoreOptions.TMP_DIRS));
    }

    @Nonnull
    public static String[] parseLocalStateDirectories(Configuration configuration) {
        String configValue = configuration.getString(CheckpointingOptions.LOCAL_RECOVERY_TASK_MANAGER_STATE_ROOT_DIRS, "");
        return ConfigurationUtils.splitPaths(configValue);
    }

    @Nonnull
    public static String[] parseWorkingDirectories(Configuration configuration) {
        String configValue = configuration.getString(CheckpointingOptions.WORKING_DIRS, "");
        return ConfigurationUtils.splitPaths(configValue);
    }

    @Nonnull
    private static String[] splitPaths(@Nonnull String separatedPaths) {
        return separatedPaths.length() > 0 ? separatedPaths.split(",|" + File.pathSeparator) : EMPTY;
    }

    private ConfigurationUtils() {
    }
}

