/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.Serializable;
import java.util.Locale;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MemorySize
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] BYTES_UNITS = new String[]{"b", "bytes"};
    private static final String[] KILO_BYTES_UNITS = new String[]{"k", "kb", "kibibytes"};
    private static final String[] MEGA_BYTES_UNITS = new String[]{"m", "mb", "mebibytes"};
    private static final String[] GIGA_BYTES_UNITS = new String[]{"g", "gb", "gibibytes"};
    private static final String[] TERA_BYTES_UNITS = new String[]{"t", "tb", "tebibytes"};
    private static final String ALL_UNITS = MemorySize.concatenateUnits(BYTES_UNITS, KILO_BYTES_UNITS, MEGA_BYTES_UNITS, GIGA_BYTES_UNITS, TERA_BYTES_UNITS);
    private final long bytes;

    public MemorySize(long bytes) {
        Preconditions.checkArgument(bytes >= 0L, "bytes must be >= 0");
        this.bytes = bytes;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getKibiBytes() {
        return this.bytes >> 10;
    }

    public long getMebiBytes() {
        return this.bytes >> 20;
    }

    public long getGibiBytes() {
        return this.bytes >> 30;
    }

    public long getTebiBytes() {
        return this.bytes >> 40;
    }

    public int hashCode() {
        return (int)(this.bytes ^ this.bytes >>> 32);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && ((MemorySize)obj).bytes == this.bytes;
    }

    public String toString() {
        return this.bytes + " bytes";
    }

    public static MemorySize parse(String text) throws IllegalArgumentException {
        return new MemorySize(MemorySize.parseBytes(text));
    }

    public static MemorySize parse(String text, MemoryUnit defaultUnit) throws IllegalArgumentException {
        if (!MemoryUnit.hasUnit(text)) {
            return MemorySize.parse(text + defaultUnit.getUnits()[0]);
        }
        return MemorySize.parse(text);
    }

    public static long parseBytes(String text) throws IllegalArgumentException {
        long multiplier;
        long value;
        char current;
        int pos;
        Preconditions.checkNotNull(text, "text");
        String trimmed = text.trim();
        Preconditions.checkArgument(!trimmed.isEmpty(), "argument is an empty- or whitespace-only string");
        int len = trimmed.length();
        for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
        }
        String number = trimmed.substring(0, pos);
        String unit = trimmed.substring(pos).trim().toLowerCase(Locale.US);
        if (number.isEmpty()) {
            throw new NumberFormatException("text does not start with a number");
        }
        try {
            value = Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value '" + number + "' cannot be re represented as 64bit number (numeric overflow).");
        }
        if (unit.isEmpty()) {
            multiplier = 1L;
        } else if (MemorySize.matchesAny(unit, BYTES_UNITS)) {
            multiplier = 1L;
        } else if (MemorySize.matchesAny(unit, KILO_BYTES_UNITS)) {
            multiplier = 1024L;
        } else if (MemorySize.matchesAny(unit, MEGA_BYTES_UNITS)) {
            multiplier = 0x100000L;
        } else if (MemorySize.matchesAny(unit, GIGA_BYTES_UNITS)) {
            multiplier = 0x40000000L;
        } else if (MemorySize.matchesAny(unit, TERA_BYTES_UNITS)) {
            multiplier = 0x10000000000L;
        } else {
            throw new IllegalArgumentException("Memory size unit '" + unit + "' does not match any of the recognized units: " + ALL_UNITS);
        }
        long result = value * multiplier;
        if (result / multiplier != value) {
            throw new IllegalArgumentException("The value '" + text + "' cannot be re represented as 64bit number of bytes (numeric overflow).");
        }
        return result;
    }

    private static boolean matchesAny(String str, String[] variants) {
        for (String s : variants) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    private static String concatenateUnits(String[] ... allUnits) {
        StringBuilder builder = new StringBuilder(128);
        for (String[] units : allUnits) {
            builder.append('(');
            for (String unit : units) {
                builder.append(unit);
                builder.append(" | ");
            }
            builder.setLength(builder.length() - 3);
            builder.append(") / ");
        }
        builder.setLength(builder.length() - 3);
        return builder.toString();
    }

    public static enum MemoryUnit {
        BYTES(new String[]{"b", "bytes"}),
        KILO_BYTES(new String[]{"k", "kb", "kibibytes"}),
        MEGA_BYTES(new String[]{"m", "mb", "mebibytes"}),
        GIGA_BYTES(new String[]{"g", "gb", "gibibytes"}),
        TERA_BYTES(new String[]{"t", "tb", "tebibytes"});

        private String[] units;

        private MemoryUnit(String[] units) {
            this.units = units;
        }

        public String[] getUnits() {
            return this.units;
        }

        public static String getAllUnits() {
            return MemoryUnit.concatenateUnits(BYTES.getUnits(), KILO_BYTES.getUnits(), MEGA_BYTES.getUnits(), GIGA_BYTES.getUnits(), TERA_BYTES.getUnits());
        }

        public static boolean hasUnit(String text) {
            char current;
            int pos;
            Preconditions.checkNotNull(text, "text");
            String trimmed = text.trim();
            Preconditions.checkArgument(!trimmed.isEmpty(), "argument is an empty- or whitespace-only string");
            int len = trimmed.length();
            for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
            }
            String unit = trimmed.substring(pos).trim().toLowerCase(Locale.US);
            return unit.length() > 0;
        }

        private static String concatenateUnits(String[] ... allUnits) {
            StringBuilder builder = new StringBuilder(128);
            for (String[] units : allUnits) {
                builder.append('(');
                for (String unit : units) {
                    builder.append(unit);
                    builder.append(" | ");
                }
                builder.setLength(builder.length() - 3);
                builder.append(") / ");
            }
            builder.setLength(builder.length() - 3);
            return builder.toString();
        }
    }
}

