/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class MetricOptions {
    public static final ConfigOption<String> REPORTERS_LIST = ConfigOptions.key("metrics.reporters").noDefaultValue();
    public static final ConfigOption<String> REPORTER_CLASS = ConfigOptions.key("metrics.reporter.<name>.class").noDefaultValue().withDescription("The reporter class to use for the reporter named <name>.");
    public static final ConfigOption<String> REPORTER_INTERVAL = ConfigOptions.key("metrics.reporter.<name>.interval").noDefaultValue().withDescription("The reporter interval to use for the reporter named <name>.");
    public static final ConfigOption<String> REPORTER_CONFIG_PARAMETER = ConfigOptions.key("metrics.reporter.<name>.<parameter>").noDefaultValue().withDescription("Configures the parameter <parameter> for the reporter named <name>.");
    public static final ConfigOption<String> SCOPE_DELIMITER = ConfigOptions.key("metrics.scope.delimiter").defaultValue(".");
    public static final ConfigOption<String> SCOPE_NAMING_JM = ConfigOptions.key("metrics.scope.jm").defaultValue("<host>.jobmanager").withDescription("Defines the scope format string that is applied to all metrics scoped to a JobManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TM = ConfigOptions.key("metrics.scope.tm").defaultValue("<host>.taskmanager.<tm_id>").withDescription("Defines the scope format string that is applied to all metrics scoped to a TaskManager.");
    public static final ConfigOption<String> SCOPE_NAMING_JM_JOB = ConfigOptions.key("metrics.scope.jm.job").defaultValue("<host>.jobmanager.<job_name>").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a JobManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TM_JOB = ConfigOptions.key("metrics.scope.tm.job").defaultValue("<host>.taskmanager.<tm_id>.<job_name>").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a TaskManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TASK = ConfigOptions.key("metrics.scope.task").defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<task_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to a task.");
    public static final ConfigOption<String> SCOPE_NAMING_OPERATOR = ConfigOptions.key("metrics.scope.operator").defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<operator_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to an operator.");
    public static final ConfigOption<Integer> LATENCY_HISTORY_SIZE = ConfigOptions.key("metrics.latency.history-size").defaultValue(128).withDescription("Defines the number of measured latencies to maintain at each operator.");
    public static final ConfigOption<Integer> TRACING_SAMPLE_COUNT_INTERVAL = ConfigOptions.key("metrics.tracing.sample.count-interval").defaultValue(100);

    private MetricOptions() {
    }
}

