/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalBlockLocation;
import org.apache.flink.core.fs.local.LocalDataInputStream;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileStatus;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class LocalFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);
    private static final URI LOCAL_URI = OperatingSystem.isWindows() ? URI.create("file:/") : URI.create("file:///");
    private static final LocalFileSystem INSTANCE = new LocalFileSystem();
    private final URI workingDir = new File(System.getProperty("user.dir")).toURI();
    private final URI homeDir = new File(System.getProperty("user.home")).toURI();
    private final String hostName;

    public LocalFileSystem() {
        String tmp = "unknownHost";
        try {
            tmp = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not resolve local host", (Throwable)e);
        }
        this.hostName = tmp;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return new BlockLocation[]{new LocalBlockLocation(this.hostName, file.getLen())};
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new LocalFileStatus(path, this);
        }
        throw new FileNotFoundException("File " + f + " does not exist or the user running Flink ('" + System.getProperty("user.name") + "') has insufficient permissions to access it.");
    }

    @Override
    public URI getUri() {
        return LOCAL_URI;
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path(this.workingDir);
    }

    @Override
    public Path getHomeDirectory() {
        return new Path(this.homeDir);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.open(f);
    }

    @Override
    public FSDataInputStream open(Path f) throws IOException {
        File file = this.pathToFile(f);
        return new LocalDataInputStream(file);
    }

    private File pathToFile(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    @Override
    public boolean exists(Path f) throws IOException {
        File path = this.pathToFile(f);
        return path.exists();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            return new FileStatus[]{new LocalFileStatus(localf, this)};
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        FileStatus[] results = new FileStatus[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getFileStatus(new Path(f, names[i]));
        }
        return results;
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        File file = this.pathToFile(f);
        if (file.isFile()) {
            return file.delete();
        }
        if (!recursive && file.isDirectory()) {
            File[] containedFiles = file.listFiles();
            if (containedFiles == null) {
                throw new IOException("Directory " + file.toString() + " does not exist or an I/O error occurred");
            }
            if (containedFiles.length != 0) {
                throw new IOException("Directory " + file.toString() + " is not empty");
            }
        }
        return this.delete(file);
    }

    private boolean delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    boolean del = this.delete(file);
                    if (del) continue;
                    return false;
                }
            }
        } else {
            return f.delete();
        }
        return f.delete();
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        Preconditions.checkNotNull(f, "path is null");
        return this.mkdirsInternal(this.pathToFile(f));
    }

    private boolean mkdirsInternal(File file) throws IOException {
        if (file.isDirectory()) {
            return true;
        }
        if (file.exists() && !file.isDirectory()) {
            throw new FileAlreadyExistsException(file.getAbsolutePath());
        }
        File parent = file.getParentFile();
        return !(parent != null && !this.mkdirsInternal(parent) || !file.mkdir() && !file.isDirectory());
    }

    @Override
    public FSDataOutputStream create(Path filePath, FileSystem.WriteMode overwrite) throws IOException {
        Preconditions.checkNotNull(filePath, "filePath");
        if (this.exists(filePath) && overwrite == FileSystem.WriteMode.NO_OVERWRITE) {
            throw new FileAlreadyExistsException("File already exists: " + filePath);
        }
        Path parent = filePath.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        File file = this.pathToFile(filePath);
        return new LocalDataOutputStream(file);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        File srcFile = this.pathToFile(src);
        File dstFile = this.pathToFile(dst);
        File dstParent = dstFile.getParentFile();
        dstParent.mkdirs();
        try {
            Files.move(srcFile.toPath(), dstFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (SecurityException | AccessDeniedException | DirectoryNotEmptyException | NoSuchFileException ex) {
            return false;
        }
    }

    @Override
    public boolean isDistributedFS() {
        return false;
    }

    @Override
    public FileSystemKind getKind() {
        return FileSystemKind.FILE_SYSTEM;
    }

    public static URI getLocalFsURI() {
        return LOCAL_URI;
    }

    public static LocalFileSystem getSharedInstance() {
        return INSTANCE;
    }
}

