/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TimeConvertUtils;

@PublicEvolving
public class Row
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[] fields;

    public Row(int arity) {
        this.fields = new Object[arity];
    }

    public int getArity() {
        return this.fields.length;
    }

    public Object getField(int pos) {
        return this.fields[pos];
    }

    public void setField(int pos, Object value) {
        this.fields[pos] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (this.fields[i] instanceof Date || this.fields[i] instanceof Time || this.fields[i] instanceof Timestamp) {
                sb.append(TimeConvertUtils.unixDateTimeToString(this.fields[i]));
                continue;
            }
            sb.append(StringUtils.arrayAwareToString(this.fields[i]));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return Arrays.deepEquals(this.fields, row.fields);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.fields);
    }

    public static Row of(Object ... values) {
        Row row = new Row(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static Row copy(Row row) {
        Row newRow = new Row(row.fields.length);
        System.arraycopy(row.fields, 0, newRow.fields, 0, row.fields.length);
        return newRow;
    }

    public static Row project(Row row, int[] fields) {
        Row newRow = new Row(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            newRow.fields[i] = row.fields[fields[i]];
        }
        return newRow;
    }
}

