/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.sql.Time;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.TimeConvertUtils;

@PublicEvolving
public class SqlTimeParser
extends FieldParser<Time> {
    private static final Time TIME_INSTANCE = new Time(0L);
    private Time result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Time reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        String str = new String(bytes, startPos, endPos - startPos, ConfigConstants.DEFAULT_CHARSET);
        try {
            this.result = new Time(TimeConvertUtils.timeStringToUnixDate(str));
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (IllegalArgumentException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Time createValue() {
        return TIME_INSTANCE;
    }

    @Override
    public Time getLastResult() {
        return this.result;
    }

    public static final Time parseField(byte[] bytes, int startPos, int length) {
        return SqlTimeParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final Time parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int limitedLen = SqlTimeParser.nextStringLength(bytes, startPos, length, delimiter);
        if (limitedLen > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + limitedLen - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, limitedLen, ConfigConstants.DEFAULT_CHARSET);
        return new Time(TimeConvertUtils.timeStringToUnixDate(str));
    }
}

