/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class StringParser
extends FieldParser<String> {
    private boolean quotedStringParsing = false;
    private byte quoteCharacter;
    private String singleQuoteStr;
    private String doubleQuoteStr;
    private static final byte BACKSLASH = 92;
    private String result;

    public void enableQuotedStringParsing(byte quoteCharacter) {
        this.quotedStringParsing = true;
        this.quoteCharacter = quoteCharacter;
        byte[] doubleQuoteChars = new byte[]{quoteCharacter, quoteCharacter};
        this.doubleQuoteStr = new String(doubleQuoteChars);
        byte[] singleQuoteChars = new byte[]{quoteCharacter};
        this.singleQuoteStr = new String(singleQuoteChars);
    }

    public boolean isQuotedStringParsing() {
        return this.quotedStringParsing;
    }

    public byte getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, String reusable) {
        int i;
        int delimLimit = limit - delimiter.length + 1;
        if (this.quotedStringParsing && bytes[i] == this.quoteCharacter) {
            ++i;
            boolean replace = false;
            while (i < limit && (bytes[i] != this.quoteCharacter || bytes[i - 1] == 92 || i + 1 < limit && bytes[i + 1] == this.quoteCharacter)) {
                if (bytes[i - 1] != 92 && bytes[i] == this.quoteCharacter && i + 1 < limit && bytes[i + 1] == this.quoteCharacter) {
                    replace = true;
                    ++i;
                }
                ++i;
            }
            if (i == limit) {
                this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
                return -1;
            }
            if (++i == limit) {
                this.result = new String(bytes, startPos + 1, i - startPos - 2, this.getCharset());
                if (replace) {
                    this.result = this.result.replace(this.doubleQuoteStr, this.singleQuoteStr);
                }
                return limit;
            }
            if (i < delimLimit && StringParser.delimiterNext(bytes, i, delimiter)) {
                this.result = new String(bytes, startPos + 1, i - startPos - 2, this.getCharset());
                if (replace) {
                    this.result = this.result.replace(this.doubleQuoteStr, this.singleQuoteStr);
                }
                return i + delimiter.length;
            }
            this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
            return -1;
        }
        for (i = startPos; i < delimLimit && !StringParser.delimiterNext(bytes, i, delimiter); ++i) {
        }
        if (i >= delimLimit) {
            if (limit == startPos) {
                this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
            }
            this.result = new String(bytes, startPos, limit - startPos, this.getCharset());
            return limit;
        }
        if (i == startPos) {
            this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
        }
        this.result = new String(bytes, startPos, i - startPos, this.getCharset());
        return i + delimiter.length;
    }

    @Override
    public String createValue() {
        return "";
    }

    @Override
    public String getLastResult() {
        return this.result;
    }
}

