/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

public final class FileUtils {
    private static final Object WINDOWS_DELETE_LOCK = new Object();
    private static final char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int RANDOM_FILE_NAME_LENGTH = 12;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 8192;

    public static void writeCompletely(WritableByteChannel channel, ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            channel.write(src);
        }
    }

    public static String getRandomFilename(String prefix) {
        Random rnd = new Random();
        StringBuilder stringBuilder = new StringBuilder(prefix);
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(ALPHABET[rnd.nextInt(ALPHABET.length)]);
        }
        return stringBuilder.toString();
    }

    public static String readFile(File file, String charsetName) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, charsetName);
    }

    public static String readFileUtf8(File file) throws IOException {
        return FileUtils.readFile(file, "UTF-8");
    }

    public static void writeFile(File file, String contents, String encoding) throws IOException {
        byte[] bytes = contents.getBytes(encoding);
        Files.write(file.toPath(), bytes, StandardOpenOption.WRITE);
    }

    public static void writeFileUtf8(File file, String contents) throws IOException {
        FileUtils.writeFile(file, contents, "UTF-8");
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(java.nio.file.Path path, int directBufferSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] read(InputStream source, int initialSize, int directBufferSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        int n = directBufferSize = directBufferSize <= 0 ? 8192 : directBufferSize;
        while (true) {
            int n2;
            if ((n2 = source.read(buf, nread, Math.min(capacity - nread, directBufferSize))) > 0) {
                nread += n2;
                continue;
            }
            if (n2 < 0 || (n2 = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 8192);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n2;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        Preconditions.checkNotNull(file, "file");
        FileUtils.guardIfWindows(FileUtils::deleteFileOrDirectoryInternal, file);
    }

    public static void deleteDirectory(File directory) throws IOException {
        Preconditions.checkNotNull(directory, "directory");
        FileUtils.guardIfWindows(FileUtils::deleteDirectoryInternal, directory);
    }

    public static void deleteDirectoryQuietly(File directory) {
        if (directory == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        Preconditions.checkNotNull(directory, "directory");
        FileUtils.guardIfWindows(FileUtils::cleanDirectoryInternal, directory);
    }

    private static void deleteFileOrDirectoryInternal(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryInternal(file);
        } else {
            Files.deleteIfExists(file.toPath());
        }
    }

    private static void deleteDirectoryInternal(File directory) throws IOException {
        if (directory.isDirectory()) {
            try {
                FileUtils.cleanDirectoryInternal(directory);
            }
            catch (FileNotFoundException ignored) {
                return;
            }
            Files.deleteIfExists(directory.toPath());
        } else if (directory.exists()) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private static void cleanDirectoryInternal(File directory) throws IOException {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files == null) {
                if (directory.exists()) {
                    throw new IOException("Failed to list contents of " + directory);
                }
                throw new FileNotFoundException(directory.toString());
            }
            for (File file : files) {
                if (file == null) continue;
                FileUtils.deleteFileOrDirectory(file);
            }
        } else {
            if (directory.exists()) {
                throw new IOException(directory + " is not a directory but a regular file");
            }
            throw new FileNotFoundException(directory.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guardIfWindows(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        if (!OperatingSystem.isWindows()) {
            toRun.accept(file);
        } else {
            Object object = WINDOWS_DELETE_LOCK;
            synchronized (object) {
                for (int attempt = 1; attempt <= 10; ++attempt) {
                    try {
                        toRun.accept(file);
                        break;
                    }
                    catch (AccessDeniedException accessDeniedException) {
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("operation interrupted");
                        }
                    }
                }
            }
        }
    }

    public static boolean deletePathIfEmpty(FileSystem fileSystem, Path path) throws IOException {
        FileStatus[] fileStatuses;
        try {
            fileStatuses = fileSystem.listStatus(path);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        if (fileStatuses == null) {
            return true;
        }
        if (fileStatuses.length == 0) {
            return fileSystem.delete(path, false);
        }
        return false;
    }

    public static void copy(Path sourcePath, Path targetPath, boolean executable) throws IOException {
        FileSystem sFS = FileSystem.getUnguardedFileSystem(sourcePath.toUri());
        FileSystem tFS = FileSystem.getUnguardedFileSystem(targetPath.toUri());
        if (!tFS.exists(targetPath)) {
            if (sFS.getFileStatus(sourcePath).isDir()) {
                FileStatus[] contents;
                tFS.mkdirs(targetPath);
                for (FileStatus content : contents = sFS.listStatus(sourcePath)) {
                    String distPath = content.getPath().toString();
                    if (content.isDir() && distPath.endsWith("/")) {
                        distPath = distPath.substring(0, distPath.length() - 1);
                    }
                    String localPath = targetPath.toString() + distPath.substring(distPath.lastIndexOf("/"));
                    FileUtils.copy(content.getPath(), new Path(localPath), executable);
                }
            } else {
                try (FSDataOutputStream lfsOutput = tFS.create(targetPath, FileSystem.WriteMode.NO_OVERWRITE);
                     FSDataInputStream fsInput = sFS.open(sourcePath);){
                    IOUtils.copyBytes(fsInput, lfsOutput);
                    new File(targetPath.toString()).setExecutable(executable);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private FileUtils() {
    }
}

