/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util.editor;

import java.beans.PropertyEditorSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class NacosCustomBooleanEditor
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String VALUE_1 = "1";
    public static final String VALUE_0 = "0";
    @Nullable
    private final String trueString;
    @Nullable
    private final String falseString;
    private final boolean allowEmpty;

    public NacosCustomBooleanEditor(boolean allowEmpty) {
        this(null, null, allowEmpty);
    }

    public NacosCustomBooleanEditor(@Nullable String trueString, @Nullable String falseString, boolean allowEmpty) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(this.convert(String.valueOf(value)));
    }

    public Object convert(String text) throws IllegalArgumentException {
        String input;
        String string = input = text != null ? text.trim() : null;
        if (this.allowEmpty && !StringUtils.hasLength((String)input)) {
            return null;
        }
        if (this.trueString != null && this.trueString.equalsIgnoreCase(input)) {
            return Boolean.TRUE;
        }
        if (this.falseString != null && this.falseString.equalsIgnoreCase(input)) {
            return Boolean.FALSE;
        }
        if (this.trueString == null && (VALUE_TRUE.equalsIgnoreCase(input) || VALUE_ON.equalsIgnoreCase(input) || VALUE_YES.equalsIgnoreCase(input) || VALUE_1.equals(input))) {
            return Boolean.TRUE;
        }
        if (this.falseString == null && (VALUE_FALSE.equalsIgnoreCase(input) || VALUE_OFF.equalsIgnoreCase(input) || VALUE_NO.equalsIgnoreCase(input) || VALUE_0.equals(input))) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
    }

    @Override
    public String getAsText() {
        String t = String.valueOf(this.getValue());
        if (Boolean.TRUE.equals(Boolean.valueOf(t))) {
            return this.trueString != null ? this.trueString : VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(Boolean.valueOf(t))) {
            return this.falseString != null ? this.falseString : VALUE_FALSE;
        }
        return "";
    }
}

