/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl;

import com.alibaba.citrus.dev.handler.impl.AbstractExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.BeansVisitor;
import com.alibaba.citrus.dev.handler.impl.visitor.ConfigurationsVisitor;
import com.alibaba.citrus.dev.handler.impl.visitor.PullToolsVisitor;
import com.alibaba.citrus.dev.handler.impl.visitor.ResolvableDepsVisitor;
import com.alibaba.citrus.dev.handler.impl.visitor.ResourcesVisitor;
import com.alibaba.citrus.dev.handler.impl.visitor.UrisVisitor;
import com.alibaba.citrus.dev.handler.util.ConfigurationFileReader;
import com.alibaba.citrus.service.pull.PullService;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.uribroker.URIBrokerService;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.IOException;
import java.util.Map;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerHandler
extends AbstractExplorerHandler {
    private static final Map<String, String> AVAILABLE_FUNCTIONS = CollectionUtil.createLinkedHashMap();

    @Override
    protected Map<String, String> getAvailableFunctions() {
        return AVAILABLE_FUNCTIONS;
    }

    @Override
    protected String getDefaultFunction() {
        return "Beans";
    }

    @Override
    protected ExplorerVisitor getBodyVisitor(RequestHandlerContext context) {
        return new ExplorerVisitor(context);
    }

    @Override
    protected String[] getStyleSheets() {
        return new String[]{"explorer.css"};
    }

    @Override
    protected String[] getJavaScripts() {
        return new String[]{"explorer.js"};
    }

    static {
        AVAILABLE_FUNCTIONS.put("Beans", "Beans");
        AVAILABLE_FUNCTIONS.put("Configurations", "Configurations");
        AVAILABLE_FUNCTIONS.put("ResolvableDependencies", "Resolvable Dependencies");
        AVAILABLE_FUNCTIONS.put("Resources", "Resources");
        AVAILABLE_FUNCTIONS.put("URIs", "URIs");
        AVAILABLE_FUNCTIONS.put("PullTools", "Pull Tools");
    }

    public class ExplorerVisitor
    extends AbstractExplorerHandler.AbstractExplorerVisitor {
        public ExplorerVisitor(RequestHandlerContext context) {
            super(context);
        }

        public Object visitBeans(Template beansTemplate) {
            return new BeansVisitor(this.context, this);
        }

        public Object visitConfigurations(Template configurationsTemplate) throws IOException {
            return new ConfigurationsVisitor(this.context, this, new ConfigurationFileReader((ResourceLoader)this.appcontext, this.configLocations).toConfigurationFiles());
        }

        public Object visitResolvableDependencies(Template resolvableDepsTemplate) {
            return new ResolvableDepsVisitor(this.context, this);
        }

        public Object visitResources(Template resourcesTemplate) {
            return new ResourcesVisitor(this.context, this, this.getService("resourceLoadingService", ResourceLoadingService.class));
        }

        public Object visitUris(Template urisTemplate) {
            return new UrisVisitor(this.context, this, this.getService("uriBrokerService", URIBrokerService.class));
        }

        public Object visitPullTools(Template pullToolsTemplate) {
            return new PullToolsVisitor(this.context, this, this.getService("pullService", PullService.class));
        }
    }
}

