/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.service.pull.PullContext;
import com.alibaba.citrus.service.pull.PullService;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullToolsVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final PullService tools;
    private final Entry rootEntry;
    private Entry entry;
    private Set<String> visitedName = CollectionUtil.createHashSet();

    public PullToolsVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v, PullService tools) {
        super(context, v);
        this.tools = tools;
        this.rootEntry = new Entry(null);
        PullContext pullContext = tools.getContext();
        boolean parentEntry = false;
        String[] names = pullContext.getQualifiedToolNames().toArray(BasicConstant.EMPTY_STRING_ARRAY);
        Arrays.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int p2;
                int p1 = o1.startsWith("/_parent/") ? 1 : 0;
                int n = p2 = o2.startsWith("/_parent/") ? 1 : 0;
                if (p1 == p2) {
                    return o1.compareTo(o2);
                }
                return p1 - p2;
            }
        });
        for (String path : names) {
            Entry entry = this.rootEntry;
            String[] pathsegs = StringUtil.split(path, "/");
            String name = null;
            String[] arr$ = pathsegs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String pathseg;
                name = pathseg = arr$[i$];
                Entry subEntry = (Entry)entry.subEntries.get(name);
                if (subEntry == null) {
                    subEntry = new Entry(name);
                    entry.subEntries.put(name, subEntry);
                }
                entry = subEntry;
                if (!parentEntry && "_parent".equals(entry.name)) {
                    parentEntry = true;
                }
                entry.parentEntry = parentEntry;
            }
            try {
                entry.value = pullContext.pull(name);
            }
            catch (Exception e) {
                entry.value = e;
            }
        }
    }

    public void visitService(Template serviceNotAvailableTemplate, Template serviceTemplate) {
        if (this.tools == null) {
            serviceNotAvailableTemplate.accept(this);
        } else {
            this.entry = this.rootEntry;
            serviceTemplate.accept(this);
        }
    }

    public void visitTool(Template toolTemplate) {
        for (Entry this.entry : this.entry.subEntries.values()) {
            toolTemplate.accept(this);
        }
    }

    public void visitToolName(Template toolWithValueTemplate, Template toolWithoutValueTemplate) {
        if (this.entry.value != null) {
            toolWithValueTemplate.accept(this);
        } else {
            toolWithoutValueTemplate.accept(this);
        }
    }

    public void visitToolHidden(Template toolHiddenTemplate) {
        if (this.entry.parentEntry && this.entry.value != null && this.visitedName.contains(this.entry.name)) {
            toolHiddenTemplate.accept(this);
        }
    }

    public void visitName() {
        String name = this.entry.name;
        if (this.entry.parentEntry) {
            if ("_parent".equals(this.entry.name)) {
                name = "Inherited from Parent Context";
            }
        } else if (this.entry.value != null) {
            this.visitedName.add(name);
        }
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(name));
    }

    public void visitSubTools(Template subToolsTemplate) {
        if (!this.entry.subEntries.isEmpty()) {
            subToolsTemplate.accept(this);
        }
    }

    public void visitToolValue(Template toolValueTemplate) {
        if (this.entry.value != null) {
            toolValueTemplate.accept(this);
        }
    }

    public void visitValueTypePackage() {
        try {
            if (this.entry.value != null) {
                ((PrintWriter)this.out()).print(this.entry.value.getClass().getPackage().getName() + ".");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void visitValueTypeName() {
        ((PrintWriter)this.out()).print(ClassUtil.getSimpleClassName(this.entry.value.getClass(), false));
    }

    public void visitValue() {
        String s = this.entry.value instanceof Throwable ? ExceptionUtil.getStackTrace(ExceptionUtil.getRootCause((Throwable)this.entry.value)) : this.entry.value.toString();
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(s));
    }

    public void visitToolId() {
        ((PrintWriter)this.out()).print(ObjectUtil.identityHashCode(this.entry));
    }

    private class Entry {
        private final String name;
        private final Map<String, Entry> subEntries = CollectionUtil.createLinkedHashMap();
        private Object value;
        private boolean parentEntry;

        public Entry(String name) {
            this.name = StringUtil.trimToNull(name);
        }
    }
}

