/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype;

import com.alibaba.citrus.generictype.ArrayTypeInfo;
import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.FieldInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.MethodInfo;
import com.alibaba.citrus.generictype.ParameterizedTypeInfo;
import com.alibaba.citrus.generictype.RawTypeInfo;
import com.alibaba.citrus.util.Assert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TypeInfo {
    public static final Factory factory = Factory.access$000();
    public static final RawTypeInfo OBJECT = (RawTypeInfo)factory.getType((Type)((Object)Object.class));
    public static final RawTypeInfo PRIMITIVE_BOOLEAN = (RawTypeInfo)factory.getType(Boolean.TYPE);
    public static final RawTypeInfo PRIMITIVE_BYTE = (RawTypeInfo)factory.getType(Byte.TYPE);
    public static final RawTypeInfo PRIMITIVE_CHAR = (RawTypeInfo)factory.getType(Character.TYPE);
    public static final RawTypeInfo PRIMITIVE_DOUBLE = (RawTypeInfo)factory.getType(Double.TYPE);
    public static final RawTypeInfo PRIMITIVE_FLOAT = (RawTypeInfo)factory.getType(Float.TYPE);
    public static final RawTypeInfo PRIMITIVE_INT = (RawTypeInfo)factory.getType(Integer.TYPE);
    public static final RawTypeInfo PRIMITIVE_LONG = (RawTypeInfo)factory.getType(Long.TYPE);
    public static final RawTypeInfo PRIMITIVE_SHORT = (RawTypeInfo)factory.getType(Short.TYPE);
    public static final RawTypeInfo PRIMITIVE_VOID = (RawTypeInfo)factory.getType(Void.TYPE);

    public Class<?> getRawType();

    public String getName();

    public String getSimpleName();

    public boolean isPrimitive();

    public boolean isArray();

    public boolean isInterface();

    public TypeInfo getPrimitiveWrapperType();

    public TypeInfo getComponentType();

    public TypeInfo getDirectComponentType();

    public int getDimension();

    public List<TypeInfo> getInterfaces();

    public List<TypeInfo> getSuperclasses();

    public List<TypeInfo> getSupertypes();

    public TypeInfo getSupertype(Class<?> var1);

    public TypeInfo resolve(GenericDeclarationInfo var1);

    public TypeInfo resolve(GenericDeclarationInfo var1, boolean var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory {
        public abstract TypeInfo getType(Type var1);

        public final ClassTypeInfo getClassType(Class<?> type) {
            Assert.assertTrue(type != null && !type.isArray(), "type should not be array: %s", type.getName());
            return (ClassTypeInfo)this.getType(type);
        }

        public final ClassTypeInfo getClassType(ParameterizedType type) {
            return (ClassTypeInfo)this.getType(type);
        }

        public abstract TypeInfo[] getTypes(Type[] var1);

        public abstract GenericDeclarationInfo getGenericDeclaration(GenericDeclaration var1);

        public abstract ParameterizedTypeInfo getParameterizedType(TypeInfo var1, TypeInfo ... var2);

        public final ParameterizedTypeInfo getParameterizedType(TypeInfo type, Type ... args) {
            return this.getParameterizedType(type, this.getTypes(args));
        }

        public final ParameterizedTypeInfo getParameterizedType(Class<?> type, Type ... args) {
            return this.getParameterizedType(this.getType(type), this.getTypes(args));
        }

        public abstract ArrayTypeInfo getArrayType(TypeInfo var1, int var2);

        public final ArrayTypeInfo getArrayType(Class<?> componentType, int dimension) {
            return this.getArrayType(this.getType(componentType), dimension);
        }

        public final MethodInfo getMethod(Method method) {
            return (MethodInfo)this.getGenericDeclaration(method);
        }

        public final MethodInfo getMethod(Method method, TypeInfo type) {
            MethodInfo result = this.getMethod(method);
            if (type != null) {
                Class<?> rawType = type.getRawType();
                Assert.assertTrue(method.getDeclaringClass().isAssignableFrom(rawType), "method \"%s\" does not belong to type \"%s\"", method, type);
                if (type instanceof ClassTypeInfo) {
                    result = result.resolve((ClassTypeInfo)type, false);
                }
            }
            return result;
        }

        public final MethodInfo getConstructor(Constructor<?> constructor) {
            return (MethodInfo)this.getGenericDeclaration(constructor);
        }

        public final MethodInfo getConstructor(Constructor<?> constructor, TypeInfo type) {
            MethodInfo result = this.getConstructor(constructor);
            if (type != null) {
                Class<?> rawType = type.getRawType();
                Assert.assertTrue(constructor.getDeclaringClass().equals(rawType), "constructor \"%s\" does not belong to type \"%s\"", constructor, type);
                if (type instanceof ClassTypeInfo) {
                    result = result.resolve((ClassTypeInfo)type, false);
                }
            }
            return result;
        }

        public abstract FieldInfo getField(Field var1);

        public final FieldInfo getField(Field field, TypeInfo type) {
            FieldInfo result = this.getField(field);
            if (type != null) {
                Class<?> rawType = type.getRawType();
                Assert.assertTrue(field.getDeclaringClass().isAssignableFrom(rawType), "field \"%s\" does not belong to type \"%s\"", field, type);
                if (type instanceof ClassTypeInfo) {
                    result = result.resolve((ClassTypeInfo)type, false);
                }
            }
            return result;
        }

        private static Factory newFactory() {
            String factoryImplName = Factory.class.getPackage().getName() + ".impl.TypeInfoFactory";
            Factory factoryImpl = null;
            try {
                factoryImpl = (Factory)Factory.class.getClassLoader().loadClass(factoryImplName).newInstance();
            }
            catch (Exception e) {
                Assert.unexpectedException(e, "Failed to create TypeInfo.Factory", new Object[0]);
            }
            return factoryImpl;
        }

        static /* synthetic */ Factory access$000() {
            return Factory.newFactory();
        }
    }
}

