/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype;

import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.util.Assert;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoUtil {
    public static final TypeInfo TYPE_VAR_MAP_KEY = TypeInfo.factory.getType(Map.class.getTypeParameters()[0]);
    public static final TypeInfo TYPE_VAR_MAP_VALUE = TypeInfo.factory.getType(Map.class.getTypeParameters()[1]);
    public static final TypeInfo TYPE_VAR_ITERABLE_ELEMENT = TypeInfo.factory.getType(Iterable.class.getTypeParameters()[0]);
    public static final TypeInfo TYPE_VAR_ITERATOR_ELEMENT = TypeInfo.factory.getType(Iterator.class.getTypeParameters()[0]);

    public static TypeInfo resolveParameter(Class<?> contextClass, Class<?> parentClass, int index) {
        Assert.assertNotNull(contextClass, "contextClass", new Object[0]);
        Assert.assertNotNull(parentClass, "parentClass", new Object[0]);
        Assert.assertTrue(index < parentClass.getTypeParameters().length, "index out of bound", new Object[0]);
        GenericDeclarationInfo context = TypeInfo.factory.getGenericDeclaration(contextClass);
        TypeInfo param = TypeInfo.factory.getType(parentClass.getTypeParameters()[index]);
        return param.resolve(context);
    }

    public static TypeInfo resolveMapKey(Class<?> mapClass) {
        return TypeInfoUtil.resolveMapKey(TypeInfo.factory.getClassType(mapClass));
    }

    public static TypeInfo resolveMapKey(TypeInfo mapType) {
        Assert.assertTrue(mapType != null && mapType instanceof ClassTypeInfo && Map.class.isAssignableFrom(mapType.getRawType()), "mapType: %s", mapType);
        return TYPE_VAR_MAP_KEY.resolve((ClassTypeInfo)mapType);
    }

    public static TypeInfo resolveMapValue(Class<?> mapClass) {
        return TypeInfoUtil.resolveMapValue(TypeInfo.factory.getClassType(mapClass));
    }

    public static TypeInfo resolveMapValue(TypeInfo mapType) {
        Assert.assertTrue(mapType != null && mapType instanceof ClassTypeInfo && Map.class.isAssignableFrom(mapType.getRawType()), "mapType: %s", mapType);
        return TYPE_VAR_MAP_VALUE.resolve((ClassTypeInfo)mapType);
    }

    public static TypeInfo resolveIterableElement(Class<?> iterableClass) {
        return TypeInfoUtil.resolveIterableElement(TypeInfo.factory.getClassType(iterableClass));
    }

    public static TypeInfo resolveIterableElement(TypeInfo iterableType) {
        Assert.assertTrue(iterableType != null && iterableType instanceof ClassTypeInfo && Iterable.class.isAssignableFrom(iterableType.getRawType()), "iterableType: %s", iterableType);
        return TYPE_VAR_ITERABLE_ELEMENT.resolve((ClassTypeInfo)iterableType);
    }

    public static TypeInfo resolveIteratorElement(Class<?> iteratorClass) {
        return TypeInfoUtil.resolveIteratorElement(TypeInfo.factory.getClassType(iteratorClass));
    }

    public static TypeInfo resolveIteratorElement(TypeInfo iteratorType) {
        Assert.assertTrue(iteratorType != null && iteratorType instanceof ClassTypeInfo && Iterator.class.isAssignableFrom(iteratorType.getRawType()), "iteratorType: %s", iteratorType);
        return TYPE_VAR_ITERATOR_ELEMENT.resolve((ClassTypeInfo)iteratorType);
    }
}

