/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ArrayTypeInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.impl.TypeInfoFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.LazyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTypeImpl
implements ArrayTypeInfo {
    private final Class<?> rawType;
    private final TypeInfo componentType;
    private final TypeInfo directComponentType;
    private final int dimension;
    private final LazyLoader<Supertypes, Object> supertypesLoader;

    ArrayTypeImpl(TypeInfo componentType, TypeInfo directComponentType, int dimension, Class<?> rawType) {
        this.componentType = Assert.assertNotNull(componentType, "componentType", new Object[0]);
        this.directComponentType = Assert.assertNotNull(directComponentType, "directComponentType", new Object[0]);
        this.dimension = dimension;
        Assert.assertTrue(dimension > 0, "dimension: %d", dimension);
        this.rawType = rawType == null ? ClassUtil.getArrayClass(componentType.getRawType(), dimension) : rawType;
        this.supertypesLoader = LazyLoader.getDefault(new SupertypesLoader());
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public String getName() {
        return this.rawType.getName();
    }

    @Override
    public String getSimpleName() {
        return this.rawType.getSimpleName();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public TypeInfo getPrimitiveWrapperType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public TypeInfo getDirectComponentType() {
        return this.directComponentType;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public List<TypeInfo> getInterfaces() {
        return this.supertypesLoader.getInstance().interfaces;
    }

    @Override
    public List<TypeInfo> getSuperclasses() {
        return this.supertypesLoader.getInstance().superclasses;
    }

    @Override
    public List<TypeInfo> getSupertypes() {
        return this.supertypesLoader.getInstance().supertypes;
    }

    @Override
    public TypeInfo getSupertype(Class<?> equivalentClass) {
        return TypeInfoFactory.findSupertype(this, equivalentClass);
    }

    @Override
    public TypeInfo resolve(GenericDeclarationInfo context) {
        return this.resolve(context, true);
    }

    @Override
    public TypeInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        TypeInfo resolvedComponentType = this.componentType.resolve(context, includeBaseType);
        if (resolvedComponentType == this.componentType) {
            return this;
        }
        return factory.getArrayType(resolvedComponentType, this.dimension);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.componentType.hashCode() ^ this.dimension;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        ArrayTypeImpl otherType = (ArrayTypeImpl)other;
        return this.dimension == otherType.dimension && this.componentType.equals(otherType.componentType);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getComponentType());
        for (int i = 0; i < this.dimension; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupertypesLoader
    implements LazyLoader.Loader<Supertypes, Object> {
        private SupertypesLoader() {
        }

        @Override
        public Supertypes load(Object context) {
            return new Supertypes(ArrayTypeImpl.this);
        }
    }

    private static class Supertypes {
        private static final TypeInfo[] ARRAY_SUPERTYPES;
        private final List<TypeInfo> supertypes;
        private final List<TypeInfo> interfaces;
        private final List<TypeInfo> superclasses;

        private Supertypes(ArrayTypeImpl arrayType) {
            TypeInfo componentType = arrayType.componentType;
            List<TypeInfo> componentSupertypes = componentType.getSupertypes();
            ArrayList<TypeInfo> supertypes = CollectionUtil.createArrayList(componentSupertypes.size() * 2);
            ArrayList interfaces = CollectionUtil.createArrayList();
            ArrayList superclasses = CollectionUtil.createArrayList();
            for (TypeInfo componentSupertype : componentSupertypes) {
                supertypes.add(TypeInfo.factory.getArrayType(componentSupertype, arrayType.dimension));
            }
            for (int dim = arrayType.dimension - 1; dim > 0; --dim) {
                for (TypeInfo arraySupertype : ARRAY_SUPERTYPES) {
                    supertypes.add(TypeInfo.factory.getArrayType(arraySupertype, dim));
                }
            }
            for (TypeInfo arraySupertype : ARRAY_SUPERTYPES) {
                supertypes.add(arraySupertype);
            }
            for (TypeInfo supertype : supertypes) {
                if (supertype.getRawType().isInterface()) {
                    interfaces.add(supertype);
                    continue;
                }
                superclasses.add(supertype);
            }
            supertypes.trimToSize();
            interfaces.trimToSize();
            superclasses.trimToSize();
            this.supertypes = Collections.unmodifiableList(supertypes);
            this.interfaces = Collections.unmodifiableList(interfaces);
            this.superclasses = Collections.unmodifiableList(superclasses);
        }

        static {
            TypeInfo[] interfaces = TypeInfo.factory.getTypes(Object[].class.getInterfaces());
            TypeInfo[] arraySupertypes = new TypeInfo[interfaces.length + 1];
            System.arraycopy(interfaces, 0, arraySupertypes, 0, interfaces.length);
            arraySupertypes[interfaces.length] = TypeInfo.OBJECT;
            ARRAY_SUPERTYPES = arraySupertypes;
        }
    }
}

