/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ArrayTypeInfo;
import com.alibaba.citrus.generictype.BoundedTypeInfo;
import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.FieldInfo;
import com.alibaba.citrus.generictype.FieldNotFoundException;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.MethodInfo;
import com.alibaba.citrus.generictype.MethodNotFoundException;
import com.alibaba.citrus.generictype.ParameterizedTypeInfo;
import com.alibaba.citrus.generictype.RawTypeInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.TypeVariableInfo;
import com.alibaba.citrus.generictype.WildcardTypeInfo;
import com.alibaba.citrus.generictype.impl.ArrayTypeImpl;
import com.alibaba.citrus.generictype.impl.FieldImpl;
import com.alibaba.citrus.generictype.impl.MethodImpl;
import com.alibaba.citrus.generictype.impl.ParameterizedTypeImpl;
import com.alibaba.citrus.generictype.impl.RawTypeImpl;
import com.alibaba.citrus.generictype.impl.TypeVariableImpl;
import com.alibaba.citrus.generictype.impl.UnknownWildcardTypeImpl;
import com.alibaba.citrus.generictype.impl.WildcardTypeImpl;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoFactory
extends TypeInfo.Factory {
    private final Map<Class<?>, TypeInfo> classCache = CollectionUtil.createConcurrentHashMap();
    private static Logger log = LoggerFactory.getLogger(TypeInfo.class);

    @Override
    public final TypeInfo getType(Type type) {
        return this.buildType(type, null);
    }

    @Override
    public final TypeInfo[] getTypes(Type[] types) {
        return this.buildTypes(types, null);
    }

    @Override
    public final GenericDeclarationInfo getGenericDeclaration(GenericDeclaration declaration) {
        return this.buildGenericDeclaration(declaration, null);
    }

    @Override
    public final FieldInfo getField(Field field) {
        ClassTypeInfo declaringType = this.getClassType(field.getDeclaringClass());
        TypeInfo type = this.getType(field.getGenericType());
        return new FieldImpl(field, declaringType, type);
    }

    @Override
    public final ParameterizedTypeInfo getParameterizedType(TypeInfo type, TypeInfo ... args) {
        Assert.assertTrue(type instanceof RawTypeInfo, "type should be RawTypeInfo", new Object[0]);
        ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl((RawTypeInfo)type);
        parameterizedType.init(args);
        return parameterizedType;
    }

    @Override
    public final ArrayTypeInfo getArrayType(TypeInfo componentType, int dimension) {
        ArrayTypeInfo arrayType;
        TypeInfo directComponentType;
        Assert.assertTrue(componentType instanceof RawTypeInfo || componentType instanceof ParameterizedTypeInfo || componentType instanceof TypeVariableInfo, "unsupported componentType: %s", componentType);
        Assert.assertTrue(dimension > 0, "dimension", new Object[0]);
        TypeInfo typeInfo = directComponentType = dimension == 1 ? componentType : this.getArrayType(componentType, dimension - 1);
        if (componentType instanceof RawTypeInfo) {
            Class<?> type = ClassUtil.getArrayClass(componentType.getRawType(), dimension);
            arrayType = (ArrayTypeInfo)this.getFromClassCache(type);
            if (arrayType == null) {
                arrayType = new ArrayTypeImpl(componentType, directComponentType, dimension, type);
                this.saveToClassCache(type, arrayType);
            }
        } else {
            arrayType = new ArrayTypeImpl(componentType, directComponentType, dimension, null);
        }
        return arrayType;
    }

    private TypeInfo buildType(Type type, BuildingCache buildingCache) {
        Assert.assertNotNull(type, "type", new Object[0]);
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return this.buildArrayType(clazz, buildingCache);
            }
            return this.buildRawType((Class)type, buildingCache);
        }
        if (type instanceof GenericArrayType) {
            return this.buildArrayType((GenericArrayType)type, buildingCache);
        }
        if (type instanceof ParameterizedType) {
            return this.buildParameterizedType((ParameterizedType)type, buildingCache);
        }
        if (type instanceof TypeVariable) {
            return this.buildTypeVariable((TypeVariable)type, buildingCache);
        }
        if (type instanceof WildcardType) {
            return this.buildWildcardType((WildcardType)type, buildingCache);
        }
        Assert.unreachableCode("Unknown type: %s", type);
        return null;
    }

    private TypeInfo[] buildTypes(Type[] types, BuildingCache buildingCache) {
        if (ArrayUtil.isEmptyArray(types)) {
            return new TypeInfo[0];
        }
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        TypeInfo[] typeInfos = new TypeInfo[types.length];
        for (int i = 0; i < types.length; ++i) {
            typeInfos[i] = this.buildType(types[i], buildingCache);
        }
        return typeInfos;
    }

    private GenericDeclarationInfo buildGenericDeclaration(GenericDeclaration declaration, BuildingCache buildingCache) {
        Assert.assertNotNull(declaration, "declaration", new Object[0]);
        if (declaration instanceof Class) {
            Class clazz = (Class)declaration;
            Assert.assertTrue(!clazz.isArray(), "declaration should not be array class: %s", clazz.getName());
            return this.buildRawType(clazz, buildingCache);
        }
        if (declaration instanceof Method) {
            return this.buildMethod((Method)declaration, buildingCache);
        }
        if (declaration instanceof Constructor) {
            return this.buildConstructor((Constructor)declaration, buildingCache);
        }
        Assert.unreachableCode("Unknown generic declaration: %s", declaration);
        return null;
    }

    private RawTypeInfo buildRawType(Class<?> type, BuildingCache buildingCache) {
        RawTypeImpl rawType;
        if (buildingCache != null && (rawType = buildingCache.getRawType(type)) != null) {
            return rawType;
        }
        rawType = (RawTypeImpl)this.getFromClassCache(type);
        if (rawType == null) {
            log.debug("Buiding type info: {}", type);
            rawType = new RawTypeImpl(type);
            rawType.init(this.buildTypeVariables(type, rawType, buildingCache));
            this.saveToClassCache(type, rawType);
        }
        return rawType;
    }

    private TypeVariableInfo[] buildTypeVariables(GenericDeclaration declaration, GenericDeclarationInfo declInfo, BuildingCache buildingCache) {
        TypeVariable<?>[] params = declaration.getTypeParameters();
        TypeVariableInfo[] vars = new TypeVariableInfo[params.length];
        if (buildingCache == null && params.length > 0) {
            buildingCache = new BuildingCache();
        }
        if (buildingCache != null) {
            buildingCache.setGenericDeclaration(declaration, declInfo);
        }
        for (int i = 0; i < params.length; ++i) {
            vars[i] = this.buildTypeVariable(params[i], buildingCache);
        }
        return vars;
    }

    private ArrayTypeInfo buildArrayType(Class<?> type, BuildingCache buildingCache) {
        ArrayTypeImpl arrayType = (ArrayTypeImpl)this.getFromClassCache(type);
        if (arrayType == null) {
            int dimension = 0;
            Class<?> componentClass = type;
            Class<?> directComponentClass = null;
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
                ++dimension;
                if (directComponentClass != null) continue;
                directComponentClass = componentClass;
            }
            RawTypeInfo componentType = this.buildRawType(componentClass, buildingCache);
            RawTypeInfo directComponentType = componentClass.equals(directComponentClass) ? componentType : this.buildType(directComponentClass, buildingCache);
            arrayType = new ArrayTypeImpl(componentType, directComponentType, dimension, type);
            this.saveToClassCache(type, arrayType);
        }
        return arrayType;
    }

    private ArrayTypeInfo buildArrayType(GenericArrayType type, BuildingCache buildingCache) {
        int dimension = 0;
        Type component = type;
        Type directComponent = null;
        while (true) {
            if (component instanceof Class) {
                if (!((Class)component).isArray()) break;
                component = ((Class)component).getComponentType();
            } else {
                if (!(component instanceof GenericArrayType)) break;
                component = component.getGenericComponentType();
            }
            ++dimension;
            if (directComponent != null) continue;
            directComponent = component;
        }
        TypeInfo componentType = this.buildType(component, buildingCache);
        TypeInfo directComponentType = component.equals(directComponent) ? componentType : this.buildType(directComponent, buildingCache);
        return new ArrayTypeImpl(componentType, directComponentType, dimension, null);
    }

    private ParameterizedTypeInfo buildParameterizedType(ParameterizedType type, BuildingCache buildingCache) {
        ParameterizedTypeImpl parameterizedTypeInfo;
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        if ((parameterizedTypeInfo = buildingCache.getParameterizedType(type)) == null) {
            RawTypeInfo rawType = this.buildRawType((Class)type.getRawType(), buildingCache);
            parameterizedTypeInfo = new ParameterizedTypeImpl(rawType);
            buildingCache.setParameterizedType(type, parameterizedTypeInfo);
            TypeInfo[] args = this.buildTypes(type.getActualTypeArguments(), buildingCache);
            for (int i = 0; i < args.length; ++i) {
                TypeInfo arg = args[i];
                if (!(arg instanceof WildcardTypeInfo) || !((WildcardTypeInfo)arg).isUnknown()) continue;
                TypeVariable<Class<?>> var = rawType.getRawType().getTypeParameters()[i];
                TypeInfo[] upperBounds = this.buildTypes(var.getBounds(), buildingCache);
                args[i] = new UnknownWildcardTypeImpl((WildcardTypeInfo)arg, upperBounds);
            }
            parameterizedTypeInfo.init(args);
        }
        return parameterizedTypeInfo;
    }

    private TypeVariableInfo buildTypeVariable(TypeVariable<?> type, BuildingCache buildingCache) {
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        String name = type.getName();
        GenericDeclarationInfo declaration = this.buildGenericDeclaration((GenericDeclaration)type.getGenericDeclaration(), buildingCache);
        TypeInfo[] upperBounds = this.buildTypes(type.getBounds(), buildingCache);
        return new TypeVariableImpl(name, declaration, upperBounds);
    }

    private WildcardTypeInfo buildWildcardType(WildcardType type, BuildingCache buildingCache) {
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        TypeInfo[] upperBounds = this.buildTypes(type.getUpperBounds(), buildingCache);
        TypeInfo[] lowerBounds = this.buildTypes(type.getLowerBounds(), buildingCache);
        return new WildcardTypeImpl(upperBounds, lowerBounds);
    }

    private MethodInfo buildMethod(Method method, BuildingCache buildingCache) {
        MethodImpl methodInfo;
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        if ((methodInfo = buildingCache.getMethod(method)) == null) {
            methodInfo = new MethodImpl(method);
            buildingCache.setGenericDeclaration(method, methodInfo);
            this.buildMethodOrConstructor(methodInfo, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), buildingCache);
        }
        return methodInfo;
    }

    private MethodInfo buildConstructor(Constructor<?> constructor, BuildingCache buildingCache) {
        MethodImpl methodInfo;
        if (buildingCache == null) {
            buildingCache = new BuildingCache();
        }
        if ((methodInfo = buildingCache.getConstructor(constructor)) == null) {
            methodInfo = new MethodImpl(constructor);
            buildingCache.setGenericDeclaration(constructor, methodInfo);
            this.buildMethodOrConstructor(methodInfo, null, constructor.getGenericParameterTypes(), constructor.getGenericExceptionTypes(), constructor.getDeclaringClass(), buildingCache);
        }
        return methodInfo;
    }

    private void buildMethodOrConstructor(MethodImpl method, Type returnType, Type[] parameterTypes, Type[] exceptionTypes, Class<?> declaringClass, BuildingCache buildingCache) {
        TypeVariableInfo[] vars = this.buildTypeVariables(method.declaration, method, buildingCache);
        RawTypeInfo returnTypeInfo = returnType == null ? TypeInfo.PRIMITIVE_VOID : this.buildType(returnType, buildingCache);
        TypeInfo[] parameterTypeInfos = this.buildTypes(parameterTypes, buildingCache);
        TypeInfo[] exceptionTypeInfos = this.buildTypes(exceptionTypes, buildingCache);
        RawTypeInfo declaringType = this.buildRawType(declaringClass, buildingCache);
        method.init(vars, returnTypeInfo, parameterTypeInfos, exceptionTypeInfos, declaringType);
    }

    private TypeInfo getFromClassCache(Class<?> type) {
        return this.classCache.get(type);
    }

    private void saveToClassCache(Class<?> type, TypeInfo typeInfo) {
        this.classCache.put(type, typeInfo);
    }

    static TypeInfo findSupertype(TypeInfo type, Class<?> equivalentClass) {
        for (TypeInfo supertype : type.getSupertypes()) {
            if (!supertype.getRawType().equals(equivalentClass)) continue;
            return supertype;
        }
        return null;
    }

    static TypeInfo resolveTypeVariable(TypeVariableInfo var, GenericDeclarationInfo context, boolean includeBaseType) {
        TypeInfo declarationEquivalent;
        GenericDeclarationInfo declaration = Assert.assertNotNull(var, "var", new Object[0]).getGenericDeclaration();
        TypeInfo result = null;
        if (declaration instanceof ClassTypeInfo && context instanceof ClassTypeInfo && (declarationEquivalent = TypeInfoFactory.findSupertype((ClassTypeInfo)context, ((ClassTypeInfo)declaration).getRawType())) != null) {
            if (!includeBaseType && declarationEquivalent instanceof RawTypeInfo) {
                result = var;
            } else {
                TypeInfo declarationResolved = declarationEquivalent.resolve(context, includeBaseType);
                Assert.assertTrue(declarationResolved instanceof GenericDeclarationInfo, "Unexpected declarationResolved: %s", declarationResolved);
                result = ((GenericDeclarationInfo)((Object)declarationResolved)).getActualTypeArgument(var.getName());
            }
        }
        if (result == null) {
            result = includeBaseType ? var.getUpperBounds().get(0).resolve(context, includeBaseType) : var;
        }
        return result;
    }

    static TypeInfo findNonBoundedType(TypeInfo type) {
        while (type instanceof BoundedTypeInfo) {
            type = ((BoundedTypeInfo)type).getBaseType();
        }
        return type;
    }

    static MethodInfo getMethod(ClassTypeInfo type, String methodName, Class<?> ... paramTypes) {
        Class<?> rawType = Assert.assertNotNull(type, "type", new Object[0]).getRawType();
        Method method = null;
        NoSuchMethodException notFound = null;
        try {
            method = rawType.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            notFound = e;
        }
        if (method == null) {
            try {
                method = rawType.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                notFound = e;
            }
        }
        if (method == null) {
            throw new MethodNotFoundException(notFound);
        }
        return TypeInfo.factory.getMethod(method, type);
    }

    static MethodInfo getConstructor(ClassTypeInfo type, Class<?> ... paramTypes) {
        Class<?> rawType = Assert.assertNotNull(type, "type", new Object[0]).getRawType();
        Constructor<?> constructor = null;
        NoSuchMethodException notFound = null;
        try {
            constructor = rawType.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            notFound = e;
        }
        if (constructor == null) {
            throw new MethodNotFoundException(notFound);
        }
        return TypeInfo.factory.getConstructor(constructor, type);
    }

    static FieldInfo getField(ClassTypeInfo type, ClassTypeInfo declaringType, String name) {
        Field field = null;
        try {
            field = declaringType.getRawType().getDeclaredField(name);
        }
        catch (Exception e) {
            throw new FieldNotFoundException(e);
        }
        return TypeInfo.factory.getField(field, type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildingCache
    extends HashMap<Object, GenericDeclarationInfo> {
        private static final long serialVersionUID = -2169655543193524884L;

        private BuildingCache() {
        }

        public RawTypeImpl getRawType(Class<?> type) {
            return (RawTypeImpl)super.get(type);
        }

        public MethodImpl getMethod(Method method) {
            return (MethodImpl)super.get(method);
        }

        public MethodImpl getConstructor(Constructor<?> constructor) {
            return (MethodImpl)super.get(constructor);
        }

        public ParameterizedTypeImpl getParameterizedType(ParameterizedType type) {
            return (ParameterizedTypeImpl)super.get(type);
        }

        public void setGenericDeclaration(GenericDeclaration decl, GenericDeclarationInfo declInfo) {
            super.put(decl, declInfo);
        }

        public void setParameterizedType(ParameterizedType type, ParameterizedTypeImpl typeInfo) {
            super.put(type, typeInfo);
        }
    }
}

