/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.configuration;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.form.FormService;
import com.alibaba.citrus.service.form.configuration.FormConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.form.impl.configuration.AbstractConfig;
import com.alibaba.citrus.service.form.impl.configuration.GroupConfigImpl;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.PropertyEditorRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormConfigImpl
extends AbstractConfig<FormConfig>
implements FormConfig {
    private FormService formService;
    private FormService[] importFormServices;
    private Map<String, GroupConfigImpl> groups;
    private Map<String, GroupConfigImpl> groupsByKey;
    private List<GroupConfig> groupList;
    private PropertyEditorRegistrarsSupport propertyEditorRegistrars = new PropertyEditorRegistrarsSupport();
    private Boolean converterQuiet;
    private Boolean postOnlyByDefault;
    private FormConfig.FieldKeyFormat fieldKeyFormat;
    private String messageCodePrefix;

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    public void setFormService(FormService formService) {
        this.formService = Assert.assertNotNull(formService, "formService", new Object[0]);
    }

    public void setImports(FormService[] importFromServices) {
        this.importFormServices = importFromServices;
    }

    @Override
    public boolean isConverterQuiet() {
        return this.converterQuiet == null ? true : this.converterQuiet;
    }

    public void setConverterQuiet(boolean converterQuiet) {
        this.converterQuiet = converterQuiet;
    }

    @Override
    public boolean isPostOnlyByDefault() {
        return this.postOnlyByDefault == null ? true : this.postOnlyByDefault;
    }

    public void setPostOnlyByDefault(boolean postOnlyByDefault) {
        this.postOnlyByDefault = postOnlyByDefault;
    }

    @Override
    public FormConfig.FieldKeyFormat getFieldKeyFormat() {
        return this.fieldKeyFormat == null ? FormConfig.FieldKeyFormat.compressed : this.fieldKeyFormat;
    }

    public void setFieldKeyFormat(FormConfig.FieldKeyFormat fieldKeyFormat) {
        this.fieldKeyFormat = fieldKeyFormat;
    }

    @Override
    public String getMessageCodePrefix() {
        return this.messageCodePrefix == null ? "form." : this.messageCodePrefix;
    }

    public void setMessageCodePrefix(String messageCodePrefix) {
        this.messageCodePrefix = this.normalizeMessageCodePrefix(messageCodePrefix);
    }

    private String normalizeMessageCodePrefix(String messageCodePrefix) {
        if ((messageCodePrefix = StringUtil.trimToNull(messageCodePrefix)) != null && !messageCodePrefix.endsWith(".")) {
            messageCodePrefix = messageCodePrefix + ".";
        }
        return messageCodePrefix;
    }

    @Override
    public List<GroupConfig> getGroupConfigList() {
        if (this.groupList == null) {
            return Collections.emptyList();
        }
        return this.groupList;
    }

    @Override
    public GroupConfig getGroupConfig(String groupName) {
        if (this.groups == null) {
            return null;
        }
        return this.groups.get(this.caseInsensitiveName(groupName));
    }

    @Override
    public GroupConfig getGroupConfigByKey(String groupKey) {
        return Assert.assertNotNull(this.groupsByKey, Assert.ExceptionType.ILLEGAL_STATE, "groupsByKey not inited", new Object[0]).get(groupKey);
    }

    public void setGroupConfigImplList(List<GroupConfigImpl> groupConfigList) {
        this.groups = null;
        this.addGroupConfigImplList(groupConfigList, false);
    }

    private void addGroupConfigImplList(List<GroupConfigImpl> groupConfigList, boolean importing) {
        if (groupConfigList != null) {
            if (this.groups == null) {
                this.groups = CollectionUtil.createLinkedHashMap();
            }
            for (GroupConfigImpl groupConfig : groupConfigList) {
                String groupName = this.caseInsensitiveName(groupConfig.getName());
                if (!importing) {
                    Assert.assertTrue(!this.groups.containsKey(groupName), "Duplicated group name: %s", groupConfig.getName());
                }
                if (this.groups.containsKey(groupName)) continue;
                this.groups.put(groupName, groupConfig);
            }
        }
    }

    @Override
    public PropertyEditorRegistrar getPropertyEditorRegistrar() {
        return this.propertyEditorRegistrars;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] registrars) {
        this.propertyEditorRegistrars.setPropertyEditorRegistrars(registrars);
    }

    @Override
    protected void init() throws Exception {
        if (!ArrayUtil.isEmptyArray(this.importFormServices)) {
            LinkedList<GroupConfigImpl> importGroups = CollectionUtil.createLinkedList();
            for (FormService importFormService : this.importFormServices) {
                FormConfig importFormConfig = importFormService.getFormConfig();
                for (GroupConfig importGroup : importFormConfig.getGroupConfigList()) {
                    GroupConfigImpl srcGroupConfig = (GroupConfigImpl)importGroup;
                    GroupConfigImpl newGroupConfig = new GroupConfigImpl();
                    String groupName = srcGroupConfig.getName();
                    newGroupConfig.setName(groupName);
                    newGroupConfig.extendsFrom(srcGroupConfig);
                    importGroups.add(newGroupConfig);
                }
            }
            this.addGroupConfigImplList(importGroups, true);
        }
        Assert.assertNotNull(this.groups, "no groups", new Object[0]);
        this.groupsByKey = CollectionUtil.createHashMap();
        this.groupList = CollectionUtil.createArrayList(this.groups.size());
        for (Map.Entry<String, GroupConfigImpl> entry : this.groups.entrySet()) {
            String caseInsensitiveName = entry.getKey();
            GroupConfigImpl groupConfig = entry.getValue();
            block0 : switch (this.getFieldKeyFormat()) {
                case uncompressed: {
                    groupConfig.setKey(caseInsensitiveName);
                    break;
                }
                default: {
                    for (int i = 1; i <= caseInsensitiveName.length(); ++i) {
                        String key = caseInsensitiveName.substring(0, i);
                        if (this.groupsByKey.containsKey(key)) continue;
                        groupConfig.setKey(key);
                        this.groupsByKey.put(key, groupConfig);
                        break block0;
                    }
                }
            }
            this.groupsByKey.put(caseInsensitiveName, groupConfig);
            groupConfig.setFormConfig(this);
            this.groupList.add(groupConfig);
        }
        this.groupList = Collections.unmodifiableList(this.groupList);
        HashSet<GroupConfigImpl> processedGroups = CollectionUtil.createHashSet();
        GroupStack processingGroups = new GroupStack();
        for (GroupConfig groupConfig : this.getGroupConfigList()) {
            this.processGroup((GroupConfigImpl)groupConfig, processedGroups, processingGroups);
        }
    }

    private void processGroup(GroupConfigImpl groupConfig, Set<GroupConfigImpl> processedGroups, GroupStack processingGroups) throws Exception {
        if (!processedGroups.contains(groupConfig)) {
            if (groupConfig.getParentGroup() != null || !groupConfig.getImports().isEmpty()) {
                if (processingGroups.contains(groupConfig)) {
                    StringBuilder buf = new StringBuilder();
                    for (GroupConfigImpl group : processingGroups) {
                        if (buf.length() == 0) {
                            buf.append("Cycle detected: ");
                        } else {
                            buf.append(" -> ");
                        }
                        buf.append(group.getName());
                    }
                    buf.append(" -> ").append(groupConfig.getName());
                    throw new IllegalArgumentException(buf.toString());
                }
                processingGroups.push(groupConfig);
                if (groupConfig.getParentGroup() != null) {
                    this.copyFields(groupConfig, groupConfig.getParentGroup(), null, true, processedGroups, processingGroups);
                }
                for (GroupConfig.Import impot : groupConfig.getImports()) {
                    this.copyFields(groupConfig, impot.getGroupName(), impot.getFieldName(), false, processedGroups, processingGroups);
                }
                processingGroups.pop();
            }
            processedGroups.add(groupConfig);
            groupConfig.init2();
        }
    }

    private void copyFields(GroupConfigImpl targetGroup, String srcGroupName, String srcFieldName, boolean isExtends, Set<GroupConfigImpl> processedGroups, GroupStack processingGroups) throws Exception {
        GroupConfigImpl srcGroup = (GroupConfigImpl)Assert.assertNotNull(this.getGroupConfig(srcGroupName), "Parent or imported group name \"%s\" not found", srcGroupName);
        this.processGroup(srcGroup, processedGroups, processingGroups);
        if (isExtends) {
            targetGroup.extendsFrom(srcGroup);
        } else {
            targetGroup.importsFrom(srcGroup, srcFieldName);
        }
    }

    @Override
    public String toString() {
        return "FormConfig[groups: " + this.getGroupConfigList().size() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupStack
    implements Iterable<GroupConfigImpl> {
        private final LinkedList<GroupConfigImpl> groups = CollectionUtil.createLinkedList();

        private GroupStack() {
        }

        public void push(GroupConfigImpl group) {
            this.groups.addLast(group);
        }

        public GroupConfigImpl pop() {
            return this.groups.removeLast();
        }

        public boolean contains(GroupConfigImpl group) {
            return this.groups.contains(group);
        }

        @Override
        public Iterator<GroupConfigImpl> iterator() {
            return this.groups.iterator();
        }

        public String toString() {
            return this.groups.toString();
        }
    }
}

