/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractOptionalValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.util.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateValidator
extends AbstractOptionalValidator {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private String dateFormatStr;
    private Date minDate;
    private String minDateStr;
    private Date maxDate;
    private String maxDateStr;

    public String getFormat() {
        return this.dateFormatStr;
    }

    public void setFormat(String formatStr) {
        this.dateFormatStr = StringUtil.trimToNull(formatStr);
    }

    public String getMinDate() {
        return this.minDateStr;
    }

    public void setMinDate(String minDate) {
        this.minDateStr = StringUtil.trimToNull(minDate);
    }

    public String getMaxDate() {
        return this.maxDateStr;
    }

    public void setMaxDate(String maxDate) {
        this.maxDateStr = StringUtil.trimToNull(maxDate);
    }

    private DateFormat getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatStr);
        sdf.setLenient(false);
        return sdf;
    }

    protected void init() throws Exception {
        super.init();
        if (this.dateFormatStr == null) {
            this.dateFormatStr = DEFAULT_DATE_FORMAT;
        }
        DateFormat format = this.getDateFormat();
        if (this.minDateStr != null) {
            this.minDate = format.parse(this.minDateStr);
            this.minDateStr = format.format(this.minDate);
        }
        if (this.maxDateStr != null) {
            this.maxDate = format.parse(this.maxDateStr);
            this.maxDateStr = format.format(this.maxDate);
        }
    }

    protected boolean validate(Validator.Context context, String value) {
        Date inputDate;
        DateFormat format = this.getDateFormat();
        try {
            inputDate = format.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        if (this.minDate != null && inputDate.before(this.minDate)) {
            return false;
        }
        return this.maxDate == null || !inputDate.after(this.maxDate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<DateValidator> {
    }
}

