/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.freemarker.impl;

import com.alibaba.citrus.service.freemarker.FreeMarkerConfiguration;
import com.alibaba.citrus.service.freemarker.FreeMarkerPlugin;
import com.alibaba.citrus.service.freemarker.impl.SpringResourceLoaderAdapter;
import com.alibaba.citrus.service.freemarker.support.DefaultBeansWrapper;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import freemarker.cache.StrongCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerConfigurationImpl
implements FreeMarkerConfiguration {
    private final Logger log;
    private final Configuration configuration = new Configuration();
    private final Map<String, String> properties = CollectionUtil.createHashMap();
    private boolean productionMode = true;
    private ResourceLoader loader;
    private TemplateLoader templateLoader;
    private String path;
    private String charset;
    private FreeMarkerPlugin[] plugins;

    public FreeMarkerConfigurationImpl(Logger log) {
        this.log = Assert.assertNotNull(log, "log", new Object[0]);
    }

    @Override
    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.loader;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    public void setPath(String path) {
        this.path = StringUtil.trimToNull(path);
    }

    public void setTemplateEncoding(String charset) {
        this.charset = StringUtil.trimToNull(charset);
    }

    public void setAdvancedProperties(Map<String, String> configuration) {
        this.properties.clear();
        this.properties.putAll(configuration);
    }

    public void setPlugins(FreeMarkerPlugin[] plugins) {
        this.plugins = plugins;
    }

    public void init() {
        this.removeReservedProperties();
        this.initProperties();
        this.initPlugins();
        this.initWrapper();
    }

    private void removeReservedProperties() {
        HashSet<String> keysToRemove = CollectionUtil.createHashSet();
        keysToRemove.add("default_encoding");
        keysToRemove.add("localized_lookup");
        for (String key : keysToRemove) {
            if (!this.properties.containsKey(key)) continue;
            this.log.warn("Removed reserved property: {} = {}", (Object)key, (Object)this.properties.get(key));
            this.properties.remove(key);
        }
    }

    private void initProperties() {
        Assert.assertNotNull(this.loader, "resourceLoader", new Object[0]);
        if (this.charset == null) {
            this.charset = "UTF-8";
        }
        this.path = ObjectUtil.defaultIfNull(this.path, "/templates");
        this.templateLoader = new SpringResourceLoaderAdapter(this.loader, this.path);
        this.configuration.setTemplateLoader(this.templateLoader);
        this.setDefaultProperty("cache_storage", StrongCacheStorage.class.getName());
        this.setDefaultProperty("template_exception_handler", "rethrow");
        this.setDefaultProperty("default_encoding", this.charset);
        this.setDefaultProperty("output_encoding", "UTF-8");
        this.setDefaultProperty("localized_lookup", "false");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String value = StringUtil.trimToNull(entry.getValue());
            if (value == null) continue;
            try {
                this.configuration.setSetting(key, value);
            }
            catch (TemplateException e) {
                throw new com.alibaba.citrus.service.template.TemplateException("invalid key and value: " + key + " = " + value, e);
            }
        }
    }

    private void initPlugins() {
        if (this.plugins != null) {
            for (FreeMarkerPlugin plugin : this.plugins) {
                plugin.init(this);
            }
        }
    }

    private void initWrapper() {
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultBeansWrapper(this.configuration.getObjectWrapper()));
    }

    private void setDefaultProperty(String key, String value) {
        if (this.properties.get(key) == null) {
            this.properties.put(key, value);
        }
    }

    public String toString() {
        return new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true).appendAll(this.properties).toString();
    }
}

