/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.factory;

import com.alibaba.citrus.service.moduleloader.impl.factory.AbstractModuleFactoryDefinitionParser;
import com.alibaba.citrus.service.moduleloader.impl.factory.ScriptModuleFactory;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.PathNameWildcardCompiler;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scripting.config.LangNamespaceUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptModuleFactoryDefinitionParser
extends AbstractModuleFactoryDefinitionParser<ScriptModuleFactory> {
    private static final String LANG_URI = "http://www.springframework.org/schema/lang";
    private static final String SCRIPT_SOURCE_ATTRIBUTE = "script-source";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map<String, AbstractModuleFactoryDefinitionParser.ParsingModuleInfo> scripts = this.parseSpecificBeans(element, parserContext, builder.getRawBeanDefinition(), DomUtil.ns(LANG_URI));
        DomUtil.ElementSelector searchFolders = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("search-folders"));
        DomUtil.ElementSelector searchFiles = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("search-files"));
        for (Element subElement : DomUtil.subElements(element)) {
            String prefix = null;
            String typeName = null;
            String moduleName = null;
            Pattern scriptNamePattern = null;
            String scriptResourceName = null;
            String language = null;
            if (searchFolders.accept(subElement)) {
                String folderName = Assert.assertNotNull(PathNameWildcardCompiler.normalizePathName(subElement.getAttribute("folders")), "no folder name provided for search-folders", new Object[0]);
                prefix = this.getPrefix(folderName);
                if (prefix != null) {
                    folderName = folderName.substring(prefix.length() + 1);
                }
                if (folderName.startsWith("/")) {
                    folderName = folderName.substring(1);
                }
                scriptNamePattern = PathNameWildcardCompiler.compilePathName(folderName);
                typeName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("type")), "no type name provided", new Object[0]);
                language = StringUtil.trimToNull(subElement.getAttribute("language"));
                scriptResourceName = folderName + "/**/*.*";
                this.log.trace("Searching in folders: {}, moduleType={}, language={}", new Object[]{folderName, typeName, language == null ? "auto" : language});
            } else if (searchFiles.accept(subElement)) {
                String fileName = Assert.assertNotNull(PathNameWildcardCompiler.normalizePathName(subElement.getAttribute("files")), "no script file name provided for search-files", new Object[0]);
                Assert.assertTrue(!fileName.endsWith("/"), "invalid script file name: %s", fileName);
                prefix = this.getPrefix(fileName);
                if (prefix != null) {
                    fileName = fileName.substring(prefix.length() + 1);
                }
                if (fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                scriptNamePattern = PathNameWildcardCompiler.compilePathName(fileName);
                typeName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("type")), "no type name provided", new Object[0]);
                moduleName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("name")), "no module name provided", new Object[0]);
                language = StringUtil.trimToNull(subElement.getAttribute("language"));
                scriptResourceName = fileName;
                this.log.trace("Searching for script files: {}, moduleType={}, moduleName={}, language={}", new Object[]{fileName, typeName, moduleName, language == null ? "auto" : language});
            }
            if (scriptResourceName == null) continue;
            scriptResourceName = prefix == null ? scriptResourceName : prefix + ":" + scriptResourceName;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(parserContext.getReaderContext().getResourceLoader());
            int found = 0;
            try {
                Resource[] resources = resolver.getResources(scriptResourceName.replace('?', '*'));
                BeanDefinitionDefaults defaults = this.getBeanDefinitionDefaults(subElement, parserContext);
                AbstractModuleFactoryDefinitionParser.ParsingModuleMatcher matcher = new AbstractModuleFactoryDefinitionParser.ParsingModuleMatcher(scripts, scriptNamePattern, typeName, moduleName){

                    protected String getName(String name, String itemName) {
                        String ext = ScriptModuleFactoryDefinitionParser.this.getExt(itemName);
                        if (ext != null && name.endsWith("." + ext)) {
                            return name.substring(0, name.length() - ext.length() - 1);
                        }
                        return name;
                    }
                };
                for (Resource resource : resources) {
                    String resourceName;
                    URI uri;
                    if (!resource.isReadable() || (uri = resource.getURI()) == null || (resourceName = uri.normalize().toString()).endsWith(".class") || !matcher.doMatch(resourceName)) continue;
                    BeanDefinition scriptBean = this.createScriptBean(subElement, parserContext, resourceName, language, defaults);
                    String beanName = matcher.generateBeanName(resourceName, parserContext.getRegistry());
                    parserContext.getRegistry().registerBeanDefinition(beanName, scriptBean);
                    ++found;
                }
            }
            catch (IOException e) {
                parserContext.getReaderContext().error("Failed to scan resources: " + scriptResourceName, (Object)subElement, (Throwable)e);
                return;
            }
            this.log.debug("Found {} module scripts with pattern: {}", (Object)found, (Object)scriptResourceName);
        }
        this.postProcessItems(element, parserContext, builder, scripts, "search-folders or search-files");
    }

    private String getPrefix(String name) {
        String prefix = null;
        int index = name.indexOf(":");
        if (index >= 0) {
            prefix = name.substring(0, index);
            Assert.assertTrue(!prefix.contains("*") && !prefix.contains("?"), "invalid folder or file name: %s", name);
        }
        return prefix;
    }

    private BeanDefinition createScriptBean(Element element, ParserContext parserContext, String resource, String language, BeanDefinitionDefaults defaults) {
        LangNamespaceUtils.registerScriptFactoryPostProcessorIfNecessary((BeanDefinitionRegistry)parserContext.getRegistry());
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getScriptFactoryClassName(resource, language));
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        builder.addConstructorArgValue((Object)resource);
        AbstractBeanDefinition bd = builder.getBeanDefinition();
        bd.applyDefaults(defaults);
        return bd;
    }

    private String getScriptFactoryClassName(String resource, String language) {
        if (language == null) {
            language = this.getExt(resource);
        }
        Assert.assertNotNull(language, "Could not determine the script language: %s", resource);
        language = language.toLowerCase();
        if ("groovy".equals(language)) {
            return "org.springframework.scripting.groovy.GroovyScriptFactory";
        }
        if ("jruby".equals(language) || "ruby".equals(language)) {
            return "org.springframework.scripting.jruby.JRubyScriptFactory";
        }
        if ("bsh".equals(language)) {
            return "org.springframework.scripting.bsh.BshScriptFactory";
        }
        throw new IllegalArgumentException("Unsupported script language: " + language);
    }

    private String getExt(String name) {
        name = name.substring(name.lastIndexOf("/") + 1);
        int index = name.lastIndexOf(".");
        String ext = null;
        if (index > 0) {
            ext = name.substring(index + 1);
        }
        return ext;
    }

    @Override
    protected boolean getDefaultLazyInit() {
        return true;
    }

    @Override
    protected String parseItemName(ParserContext parserContext, Element element, BeanDefinition bd) {
        String resourceName = Assert.assertNotNull(StringUtil.trimToNull(element.getAttribute(SCRIPT_SOURCE_ATTRIBUTE)), "Missing Attribute: %s", SCRIPT_SOURCE_ATTRIBUTE);
        Resource resource = parserContext.getReaderContext().getResourceLoader().getResource(resourceName);
        try {
            return resource.getURI().normalize().toString();
        }
        catch (IOException e) {
            parserContext.getReaderContext().error("Failed to get resource: " + resourceName, (Object)element, (Throwable)e);
            return null;
        }
    }

    @Override
    protected String getDefaultName() {
        return "scriptModuleFactory";
    }
}

