/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Condition;
import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class IfValve
extends AbstractValve {
    private Condition condition;
    private Pipeline block;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Pipeline getBlock() {
        return this.block;
    }

    public void setBlock(Pipeline block) {
        this.block = block;
    }

    protected void init() throws Exception {
        Assert.assertNotNull(this.condition, "no condition", new Object[0]);
        Assert.assertNotNull(this.block, "no if-block", new Object[0]);
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        if (this.condition.isSatisfied(pipelineContext)) {
            this.block.newInvocation(pipelineContext).invoke();
        }
        pipelineContext.invokeNext();
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("condition", this.condition);
        mb.append("block", this.block);
        return new ToStringBuilder().append("IfValve").append(mb).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<IfValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Object condition = this.parseCondition(element, parserContext, builder);
            if (condition != null) {
                builder.addPropertyValue("condition", condition);
            }
            builder.addPropertyValue("block", this.parsePipeline(element, parserContext));
        }
    }
}

