/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pull.support;

import com.alibaba.citrus.service.pull.ToolSetFactory;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextExposerToolSet
implements ToolSetFactory,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext context;
    private Map<String, String> toolNamesAndBeanNames;

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public void setBeanNames(Map<String, String> toolNamesAndBeanNames) {
        this.toolNamesAndBeanNames = toolNamesAndBeanNames;
    }

    public void afterPropertiesSet() {
        Assert.assertNotNull(this.context, "no context", new Object[0]);
        if (this.toolNamesAndBeanNames == null) {
            this.toolNamesAndBeanNames = CollectionUtil.createHashMap();
        }
        for (Map.Entry<String, String> entry : this.toolNamesAndBeanNames.entrySet()) {
            String toolName = Assert.assertNotNull(StringUtil.trimToNull(entry.getKey()), "missing tool name", new Object[0]);
            String beanName = StringUtil.trimToNull(entry.getValue());
            if (beanName != null) continue;
            beanName = toolName;
            entry.setValue(beanName);
        }
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Iterable<String> getToolNames() {
        return this.toolNamesAndBeanNames.keySet();
    }

    @Override
    public Object createTool(String name) throws Exception {
        String beanName = Assert.assertNotNull(this.toolNamesAndBeanNames.get(name), "no beanName for tool: %s", name);
        return this.context.getBean(beanName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<ContextExposerToolSet> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Map<Object, Object> names = SpringExtUtil.createManagedMap(element, parserContext);
            DomUtil.ElementSelector toolSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("tool"));
            for (Element subElement : DomUtil.subElements(element, toolSelector)) {
                String toolName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("id")), "no tool id", new Object[0]);
                String beanName = StringUtil.trimToNull(subElement.getAttribute("beanName"));
                names.put(toolName, beanName);
            }
            builder.addPropertyValue("beanNames", names);
        }
    }
}

