/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource;

public class ResourceTraceElement {
    private final String configLocation;
    private final String beanName;
    private final String patternName;
    private final String patternType;
    private final boolean internalPattern;
    private final String resourceName;

    public ResourceTraceElement(String configLocation, String beanName, String patternType, String patternName, boolean internalPattern, String resourceName) {
        this.configLocation = configLocation;
        this.beanName = beanName;
        this.patternType = patternType;
        this.patternName = patternName;
        this.internalPattern = internalPattern;
        this.resourceName = resourceName;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getPatternType() {
        return this.patternType;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public boolean isInternalPattern() {
        return this.internalPattern;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getShortLocation() {
        if (this.configLocation == null) {
            return "(unknown location)";
        }
        return this.configLocation.substring(this.configLocation.lastIndexOf("/") + 1);
    }

    public String toString() {
        String format = this.internalPattern ? "\"%s\" matched %s [pattern=\"%s\", internal=\"true\"], at \"%s\", beanName=\"%s\"" : "\"%s\" matched %s [pattern=\"%s\"], at \"%s\", beanName=\"%s\"";
        return String.format(format, this.resourceName, this.patternType, this.patternName, this.getShortLocation(), this.beanName);
    }
}

