/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.filter;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceFilter;
import com.alibaba.citrus.service.resource.ResourceFilterChain;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.support.ByteArrayResource;
import com.alibaba.citrus.service.resource.support.FileResource;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltResourceFilter
implements ResourceFilter {
    private static final Logger log = LoggerFactory.getLogger(XsltResourceFilter.class);
    private ResourceLoadingService resourceLoadingService;
    private String xslt;
    private String saveTo;
    private File saveToDir;
    private boolean failIfNotFound = true;

    public void setXslt(String xslt) {
        this.xslt = StringUtil.trimToNull(xslt);
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    public void setSaveTo(String saveTo) {
        this.saveTo = StringUtil.trimToNull(saveTo);
    }

    @Override
    public void init(ResourceLoadingService resourceLoadingService) {
        this.resourceLoadingService = Assert.assertNotNull(resourceLoadingService, "resourceLoadingService", new Object[0]);
        Assert.assertNotNull(this.xslt, "missing xslt", new Object[0]);
    }

    private File getSaveToDir() {
        File dir;
        if (this.saveToDir != null) {
            return this.saveToDir;
        }
        if (this.saveTo == null) {
            return null;
        }
        try {
            dir = this.resourceLoadingService.getResourceAsFile(this.saveTo, ResourceLoadingService.FOR_CREATE);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalArgumentException("Specified saveTo dir is not exist: " + this.saveTo, e);
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("Specified saveTo dir is not exist: " + this.saveTo);
        }
        this.saveToDir = dir;
        log.debug("Transformed resource will be saved into directory: {}", (Object)dir.getAbsolutePath());
        return this.saveToDir;
    }

    @Override
    public Resource doFilter(ResourceMatchResult filterMatchResult, Set<ResourceLoadingOption> options, ResourceFilterChain chain) throws ResourceNotFoundException {
        Resource xsltRes;
        String resourceName = filterMatchResult.getResourceName();
        String xsltName = filterMatchResult.substitute(this.xslt);
        try {
            xsltRes = this.resourceLoadingService.getResource(xsltName);
        }
        catch (ResourceNotFoundException e) {
            xsltRes = null;
        }
        if (xsltRes == null && this.failIfNotFound) {
            throw new ResourceNotFoundException("Could not find XSLT file for " + this + ", resourceName=" + filterMatchResult.getResourceName());
        }
        Resource resource = chain.doFilter(filterMatchResult, options);
        resource = this.transformDocument(resource, resourceName, xsltRes, xsltName);
        if (this.getSaveToDir() != null) {
            resource = this.saveToDir(resource, resourceName);
        }
        return resource;
    }

    private Resource transformDocument(Resource xmlRes, String xmlResName, Resource xsltRes, String xsltResName) throws ResourceNotFoundException {
        log.debug("Applying XSLT \"{}\" to resource \"{}\"", (Object)xsltResName, (Object)xmlResName);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource xsltSource = new StreamSource(xsltRes.getInputStream(), xsltResName);
            Transformer transformer = factory.newTransformer(xsltSource);
            StreamSource source = new StreamSource(xmlRes.getInputStream(), xmlResName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            return new ByteArrayResource(baos.toByteArray());
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Could not apply XSLT \"" + xsltResName + "\" to resource \"" + xmlResName + "\"", e);
        }
    }

    private Resource saveToDir(Resource resource, String resourceName) {
        File fileToSave = new File(this.saveToDir, resourceName);
        File parentDir = fileToSave.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!parentDir.exists()) {
            log.warn("Directory to save is not exist: " + parentDir.getAbsolutePath());
            return resource;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileToSave);
            StreamUtil.io(resource.getInputStream(), fos, true, true);
        }
        catch (IOException e) {
            log.warn("Could not save to file: " + fileToSave.getAbsolutePath(), (Throwable)e);
            return resource;
        }
        FileResource transformed = new FileResource(fileToSave);
        if (log.isDebugEnabled()) {
            log.debug("Transformed resource is saved to " + fileToSave.getAbsolutePath());
        }
        return transformed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.xslt + "]";
    }
}

