/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.loader;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLister;
import com.alibaba.citrus.service.resource.ResourceListerContext;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.support.FileResource;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceLoader
implements ResourceLister {
    private static final Logger log = LoggerFactory.getLogger(FileResourceLoader.class);
    private String basedir;
    private String configFileBasedir;
    private SearchPath[] paths;

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = StringUtil.trimToNull(basedir);
    }

    public String getConfigFileBasedir() {
        return this.configFileBasedir;
    }

    public void setConfigFileURL(URL configFileURL) {
        if (configFileURL != null) {
            File configFile = null;
            try {
                configFile = new File(configFileURL.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configFile != null) {
                this.configFileBasedir = configFile.getParentFile().getAbsolutePath();
            }
        }
    }

    public SearchPath[] getPaths() {
        return this.paths;
    }

    public void setPaths(SearchPath[] paths) {
        this.paths = paths;
    }

    @Override
    public void init(ResourceLoadingService resourceLoadingService) {
        if (this.basedir == null) {
            this.basedir = this.configFileBasedir;
        } else if (this.configFileBasedir != null) {
            this.basedir = FileUtil.getSystemDependentAbsolutePathBasedOn(this.configFileBasedir, this.basedir);
        }
        this.basedir = StringUtil.trimToNull(FileUtil.normalizePath(this.basedir));
        if (ArrayUtil.isEmptyArray(this.paths)) {
            this.paths = new SearchPath[]{new SearchPath("/", true)};
        }
        for (SearchPath searchPath : this.paths) {
            searchPath.init(this.basedir);
        }
    }

    @Override
    public Resource getResource(ResourceLoaderContext context, Set<ResourceLoadingOption> options) {
        File file = this.find(context, options);
        if (file != null) {
            return new FileResource(file);
        }
        return null;
    }

    @Override
    public String[] list(ResourceListerContext context, Set<ResourceLoadingOption> options) {
        File[] files;
        File file = this.find(context, options);
        File[] fileArray = files = file == null ? null : file.listFiles();
        if (files != null) {
            String[] names = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                names[i] = files[i].isDirectory() ? files[i].getName() + "/" : files[i].getName();
            }
            return names;
        }
        return null;
    }

    private File find(ResourceMatchResult context, Set<ResourceLoadingOption> options) {
        File file = null;
        log.trace("Searching for file {} in {} search-paths", (Object)context.getResourceName(), (Object)this.paths.length);
        for (SearchPath searchPath : this.paths) {
            File resourceFile = searchPath.getPath(context);
            if (log.isTraceEnabled()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Search in ").append(searchPath).append("\n");
                buf.append("  Testing file: ").append(resourceFile.getAbsolutePath());
                if (resourceFile.exists()) {
                    buf.append(", file exists");
                } else {
                    buf.append(", file does not exist");
                }
                log.trace(buf.toString());
            }
            if (resourceFile.exists()) {
                file = resourceFile;
                break;
            }
            if (options == null || !options.contains((Object)ResourceLoadingOption.FOR_CREATE) || file != null) continue;
            file = resourceFile;
        }
        return file;
    }

    public String toString() {
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(this.paths).toString();
    }

    public static class SearchPath {
        private final String path;
        private final boolean relative;
        private String basedir;

        public SearchPath(String path, boolean relative) {
            this.path = Assert.assertNotNull(StringUtil.trimToNull(FileUtil.normalizePath(path)), "path", new Object[0]);
            this.relative = relative;
        }

        public void init(String basedir) {
            if (this.relative) {
                this.basedir = Assert.assertNotNull(basedir, "Could not get basedir for search path: %s.  Please set basedir explictly at file-loader or use absolute path instead", this);
            }
        }

        public File getPath(ResourceMatchResult context) {
            String realPath = context.substitute(this.path);
            if (this.basedir != null) {
                realPath = new File(this.basedir, realPath).getAbsolutePath();
            }
            return new File(FileUtil.normalizePath(realPath));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.relative) {
                buf.append("relpath=").append(this.path);
                buf.append(", basedir=").append(this.basedir);
            } else {
                buf.append("abspath=").append(this.path);
            }
            return buf.toString();
        }
    }
}

