/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.impl;

import com.alibaba.citrus.service.uribroker.impl.URIBrokerServiceImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBrokerServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<URIBrokerServiceImpl>
implements ContributionAware {
    private ConfigurationPoint uriBrokersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.uriBrokersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/uris", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        SpringExtUtil.addConstructorArg(builder, false, HttpServletRequest.class);
        SpringExtUtil.attributesToProperties(element, builder, "requestAware", "defaultCharset");
        DomUtil.ElementSelector importSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("import"));
        List<Object> imports = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, importSelector)) {
            String urisRef = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("uris")), "import uris is empty", new Object[0]);
            imports.add(new RuntimeBeanReference(urisRef));
        }
        builder.addPropertyValue("imports", imports);
        List<Object> brokers = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder broker = SpringExtUtil.parseConfigurationPointBean(subElement, this.uriBrokersConfigurationPoint, parserContext, builder);
            if (broker == null) continue;
            BeanDefinitionBuilder infoBuilder = BeanDefinitionBuilder.genericBeanDefinition(URIBrokerServiceImpl.URIBrokerInfo.class);
            infoBuilder.addConstructorArgValue((Object)subElement.getAttribute("id"));
            infoBuilder.addConstructorArgValue((Object)subElement.getAttribute("extends"));
            infoBuilder.addConstructorArgValue((Object)StringUtil.trimToNull(subElement.getAttribute("exposed")));
            infoBuilder.addConstructorArgValue((Object)broker);
            brokers.add(infoBuilder.getBeanDefinition());
        }
        builder.addPropertyValue("brokers", brokers);
    }

    @Override
    protected String getDefaultName() {
        return "uriBrokerService, uris";
    }
}

