/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext;

import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;

public abstract class ResourceResolver {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract Resource getResource(String var1);

    public abstract Resource[] getResources(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAllProperties(String resourceName, PropertyHandler handler) throws ConfigurationPointException {
        Assert.assertNotNull(resourceName, "Resource name must not be null", new Object[0]);
        Assert.assertNotNull(handler, "No handler provided", new Object[0]);
        HashMap<String, Resource> keyToResources = CollectionUtil.createHashMap();
        try {
            for (Resource resource : this.getResources(resourceName)) {
                Properties props = new Properties();
                InputStream is = null;
                try {
                    is = resource.getInputStream();
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (keyToResources.containsKey(key)) {
                            this.log.warn("Duplicated key \"{}\" in {} and {}", new Object[]{key, resource, keyToResources.get(key)});
                            continue;
                        }
                        keyToResources.put(key, resource);
                        handler.handle(key, value, resource, -1);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Unable to load data from " + resourceName, e);
        }
    }

    public static interface PropertyHandler {
        public void handle(String var1, String var2, Resource var3, int var4);
    }

    public static abstract class Resource
    implements InputStreamSource {
        public abstract String getName();

        public abstract InputStream getInputStream() throws IOException;

        public final String toString() {
            String desc = this.getName();
            return ClassUtil.getSimpleClassName(this.getClass()) + (desc == null ? "" : "[" + desc + "]");
        }
    }
}

