/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointSettings;
import com.alibaba.citrus.springext.support.SourceInfoSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPointsImpl
implements ConfigurationPoints {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPoints.class);
    private static final String NAMESPACE_URI_KEY = "namespaceUri";
    private static final String DEFAULT_ELEMENT_KEY = "defaultElement";
    private static final String PREFERRED_NS_PREFIX = "nsPrefix";
    private final ConfigurationPointSettings settings;
    private final String configurationPointsLocation;
    private final Map<String, ConfigurationPoint> namespaceUriToConfigurationPoints;
    private final Set<String> namespaces;
    private final Map<String, ConfigurationPoint> nameToConfigurationPoints;
    private final Collection<ConfigurationPoint> configurationPoints;
    private boolean initialized;

    public ConfigurationPointsImpl() {
        this(null, null, null);
    }

    public ConfigurationPointsImpl(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public ConfigurationPointsImpl(ClassLoader classLoader, String configurationPointsLocation) {
        this(classLoader, null, configurationPointsLocation);
    }

    public ConfigurationPointsImpl(ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ConfigurationPointsImpl(ResourceResolver resourceResolver, String configurationPointsLocation) {
        this(null, Assert.assertNotNull(resourceResolver, "no resourceResolver was specified", new Object[0]), configurationPointsLocation);
    }

    private ConfigurationPointsImpl(ClassLoader classLoader, ResourceResolver resourceResolver, String configurationPointsLocation) {
        this.configurationPointsLocation = StringUtil.defaultIfEmpty(configurationPointsLocation, "META-INF/spring.configuration-points");
        this.namespaceUriToConfigurationPoints = CollectionUtil.createTreeMap();
        this.namespaces = Collections.unmodifiableSet(this.namespaceUriToConfigurationPoints.keySet());
        this.nameToConfigurationPoints = CollectionUtil.createTreeMap();
        this.configurationPoints = Collections.unmodifiableCollection(this.nameToConfigurationPoints.values());
        this.settings = resourceResolver == null ? new ConfigurationPointSettings(classLoader, this.configurationPointsLocation) : new ConfigurationPointSettings(resourceResolver, this.configurationPointsLocation);
    }

    private void ensureInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.loadConfigurationPoints();
    }

    private void loadConfigurationPoints() {
        log.trace("Trying to load configuration points at {}", (Object)this.configurationPointsLocation);
        this.settings.resourceResolver.loadAllProperties(this.configurationPointsLocation, new ResourceResolver.PropertyHandler(){

            public void handle(String key, String value, ResourceResolver.Resource source, int lineNumber) {
                String name = ConfigurationPointsImpl.this.normalizeConfigurationPointName(key);
                if (name == null) {
                    return;
                }
                Map params = ConfigurationPointsImpl.this.parseNamespaceUriAndParams(value);
                String namespaceUri = (String)Assert.assertNotNull(params.get(ConfigurationPointsImpl.NAMESPACE_URI_KEY), ConfigurationPointsImpl.NAMESPACE_URI_KEY, new Object[0]);
                if (!namespaceUri.endsWith(name)) {
                    throw new ConfigurationPointException("Naming Convention Violation: namespace URI [" + namespaceUri + "] of configuration point should end with its name [" + name + "].  This configuration point is located at " + ConfigurationPointsImpl.this.configurationPointsLocation + ".");
                }
                String defaultElementName = (String)params.get(ConfigurationPointsImpl.DEFAULT_ELEMENT_KEY);
                String preferredNsPrefix = (String)params.get(ConfigurationPointsImpl.PREFERRED_NS_PREFIX);
                ConfigurationPointImpl cp = new ConfigurationPointImpl(ConfigurationPointsImpl.this, ConfigurationPointsImpl.this.settings, name, namespaceUri, defaultElementName, preferredNsPrefix, new SourceInfoSupport().setSource(source, lineNumber));
                ConfigurationPointsImpl.this.namespaceUriToConfigurationPoints.put(namespaceUri, cp);
                ConfigurationPointsImpl.this.nameToConfigurationPoints.put(name, cp);
            }
        });
        if (log.isDebugEnabled()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Loaded configuration points at %s, %d configuration points found.", this.configurationPointsLocation, this.nameToConfigurationPoints.size());
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true);
            for (String name : this.nameToConfigurationPoints.keySet()) {
                mb.append(name, this.nameToConfigurationPoints.get(name).getNamespaceUri());
            }
            mb.appendTo(buf);
            log.debug(buf.toString());
        }
    }

    @Override
    public Set<String> getAvailableNamespaces() {
        this.ensureInit();
        return this.namespaces;
    }

    @Override
    public Collection<ConfigurationPoint> getConfigurationPoints() {
        this.ensureInit();
        return this.configurationPoints;
    }

    @Override
    public ConfigurationPoint getConfigurationPointByName(String name) {
        this.ensureInit();
        name = this.normalizeConfigurationPointName(name);
        if (name != null) {
            return this.ensureInitConfigurationPoint((ConfigurationPointImpl)this.nameToConfigurationPoints.get(name));
        }
        return null;
    }

    @Override
    public ConfigurationPoint getConfigurationPointByNamespaceUri(String namespaceUri) {
        this.ensureInit();
        namespaceUri = this.normalizeNamespaceUri(namespaceUri);
        if (namespaceUri != null) {
            return this.ensureInitConfigurationPoint((ConfigurationPointImpl)this.namespaceUriToConfigurationPoints.get(namespaceUri));
        }
        return null;
    }

    private ConfigurationPoint ensureInitConfigurationPoint(ConfigurationPointImpl cp) {
        if (cp != null) {
            cp.init();
        }
        return cp;
    }

    private String normalizeConfigurationPointName(String name) {
        return StringUtil.trimToNull(FileUtil.normalizeRelativePath(name, true));
    }

    private String normalizeNamespaceUri(String uri) {
        if ((uri = StringUtil.trimToNull(uri)) != null) {
            uri = URI.create(uri).normalize().toString().replaceAll("/$", "");
        }
        return uri;
    }

    private Map<String, String> parseNamespaceUriAndParams(String uriAndParams) {
        String[] parts;
        if ((uriAndParams = StringUtil.trimToNull(uriAndParams)) == null) {
            return null;
        }
        HashMap<String, String> params = CollectionUtil.createHashMap(4);
        for (String part : parts = uriAndParams.split(",|;")) {
            if ((part = StringUtil.trimToNull(part)) == null) continue;
            int index = part.indexOf("=");
            if (index >= 0) {
                String paramKey = StringUtil.trimToNull(part.substring(0, index));
                String paramValue = StringUtil.trimToNull(part.substring(index + 1));
                if (paramKey == null) {
                    throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
                }
                params.put(paramKey, paramValue);
                continue;
            }
            if (params.containsKey(NAMESPACE_URI_KEY)) {
                throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
            }
            params.put(NAMESPACE_URI_KEY, this.normalizeNamespaceUri(part));
        }
        if (!params.containsKey(NAMESPACE_URI_KEY)) {
            throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
        }
        return params;
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        TreeMap<String, Schema> mappings = CollectionUtil.createTreeMap();
        for (ConfigurationPoint cp : this.getConfigurationPoints()) {
            mappings.putAll(cp.getSchemas().getNamedMappings());
            for (Contribution contrib : cp.getContributions()) {
                mappings.putAll(contrib.getSchemas().getNamedMappings());
            }
        }
        return mappings;
    }

    public String toString() {
        if (!this.initialized) {
            return "ConfigurationPoints[uninitialized]";
        }
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("ConfigurationPoints[%d cps, loaded from %s]", this.configurationPoints.size(), this.configurationPointsLocation);
        if (!this.configurationPoints.isEmpty()) {
            buf.appendCollection(this.configurationPoints);
        }
        return buf.toString();
    }
}

