/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;

public abstract class SchemaBase
implements Schema {
    protected static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final InputStreamSource originalSource;
    private Document document;
    private boolean parsed;
    private final LinkedList<Schema.Transformer> transformersQueue = CollectionUtil.createLinkedList();
    private byte[] transformedData;
    private boolean everTransformed;
    private boolean analyzed;

    public SchemaBase(InputStreamSource originalSource) {
        this(originalSource, null, true);
    }

    public SchemaBase(Document originalDocument) {
        this(null, originalDocument, false);
    }

    protected SchemaBase(InputStreamSource originalSource, Document originalDocument, boolean isInputStreamSource) {
        if (isInputStreamSource) {
            this.originalSource = Assert.assertNotNull(originalSource, "no InputStreamSource provided", new Object[0]);
        } else {
            this.originalSource = null;
            this.document = Assert.assertNotNull(originalDocument, "no Document provided", new Object[0]);
            this.parsed = true;
        }
    }

    public final void transform(Schema.Transformer transformer) {
        this.transform(transformer, false);
    }

    public final void transform(Schema.Transformer transformer, boolean doNow) {
        this.transformersQueue.addLast(Assert.assertNotNull(transformer, "no Transformer provided", new Object[0]));
        if (doNow) {
            this.transform();
        }
    }

    public final Document getDocument() {
        this.parse();
        this.transform();
        return this.document;
    }

    public final InputStream getInputStream() {
        this.serialize();
        if (this.transformedData != null) {
            return new ByteArrayInputStream(this.transformedData);
        }
        if (this.originalSource != null) {
            return this.getOriginalInputStream();
        }
        Assert.fail("Found a BUG: OriginalSource can't be null here", new Object[0]);
        return null;
    }

    private void serialize() {
        this.transform();
        if (this.transformedData == null && this.document != null && (this.everTransformed || this.originalSource == null)) {
            this.transformedData = SchemaUtil.getDocumentContent(this.document);
        }
    }

    private void transform() {
        if (!this.transformersQueue.isEmpty()) {
            this.parse();
            this.transformedData = null;
            this.everTransformed = true;
            while (!this.transformersQueue.isEmpty()) {
                Schema.Transformer transformer = this.transformersQueue.removeFirst();
                if (this.document == null) continue;
                transformer.transform(this.document, this.getName());
            }
        }
    }

    private void parse() {
        if (!this.parsed) {
            this.parsed = true;
            try {
                this.document = SchemaUtil.readDocument(this.getOriginalInputStream(), this.getName(), true);
            }
            catch (DocumentException e) {
                log.warn("Not a valid XML doc: {}, source={},\n{}", new Object[]{this.getName(), this.originalSource, e.getMessage()});
                this.document = null;
            }
        }
    }

    private InputStream getOriginalInputStream() {
        try {
            return this.originalSource.getInputStream();
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Failed to read text of schema file: " + this.getName() + ", source=" + this.originalSource, e);
        }
    }

    protected final void analyze() {
        if (!this.analyzed) {
            this.analyzed = true;
            this.parse();
            this.transform();
            if (this.document != null) {
                this.doAnalyze();
            }
        }
    }

    protected abstract void doAnalyze();

    public String toString() {
        if (this.originalSource != null) {
            return this.originalSource.toString();
        }
        return "generated-content";
    }
}

