/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ClasspathResourceResolver
extends ResourceResolver {
    private final ResourcePatternResolver resolver;

    public ClasspathResourceResolver(ClassLoader classLoader) {
        this.resolver = new PathMatchingResourcePatternResolver(classLoader);
    }

    public ResourceResolver.Resource getResource(String location) {
        Resource springResource = this.resolver.getResource("classpath:" + location);
        if (springResource != null && springResource.exists()) {
            return this.createResource(springResource);
        }
        return null;
    }

    public ResourceResolver.Resource[] getResources(String locationPattern) throws IOException {
        Resource[] springResources = this.resolver.getResources("classpath*:" + locationPattern);
        if (springResources == null) {
            return new ResourceResolver.Resource[0];
        }
        ResourceResolver.Resource[] resources = new ResourceResolver.Resource[springResources.length];
        for (int i = 0; i < springResources.length; ++i) {
            resources[i] = this.createResource(springResources[i]);
        }
        return resources;
    }

    protected ResourceResolver.Resource createResource(Resource springResource) {
        return new SpringResourceAdapter(springResource);
    }

    public static class SpringResourceAdapter
    extends ResourceResolver.Resource
    implements Resource {
        private final Resource springResource;

        private SpringResourceAdapter(Resource springResource) {
            this.springResource = Assert.assertNotNull(springResource, "missing spring resource", new Object[0]);
        }

        public Resource getUnderlyingResource() {
            return this.springResource;
        }

        public String getName() {
            try {
                return this.getUnderlyingResource().getURL().toExternalForm();
            }
            catch (IOException e) {
                return this.getUnderlyingResource().getDescription();
            }
        }

        public InputStream getInputStream() throws IOException {
            return this.getUnderlyingResource().getInputStream();
        }

        public String getDescription() {
            return this.getUnderlyingResource().getDescription();
        }

        public URL getURL() throws IOException {
            return this.getUnderlyingResource().getURL();
        }

        public long contentLength() throws IOException {
            return this.getUnderlyingResource().contentLength();
        }

        public boolean isOpen() {
            return this.getUnderlyingResource().isOpen();
        }

        public boolean isReadable() {
            return this.getUnderlyingResource().isReadable();
        }

        public long lastModified() throws IOException {
            return this.getUnderlyingResource().lastModified();
        }

        public File getFile() throws IOException {
            return this.getUnderlyingResource().getFile();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.getUnderlyingResource().createRelative(relativePath);
        }

        public boolean exists() {
            return this.getUnderlyingResource().exists();
        }

        public String getFilename() {
            return this.getUnderlyingResource().getFilename();
        }

        public URI getURI() throws IOException {
            return this.getUnderlyingResource().getURI();
        }
    }
}

