/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.support;

import com.alibaba.citrus.service.pull.PullService;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitRequestContext;
import com.alibaba.citrus.service.requestcontext.parser.CookieParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.service.uribroker.URIBrokerService;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.Navigator;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.support.MappedContext;
import com.alibaba.citrus.turbine.support.PullableMappedContext;
import com.alibaba.citrus.turbine.uribroker.uri.TurbineURIBroker;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.ActionEventUtil;
import com.alibaba.citrus.webx.WebxComponent;
import com.alibaba.citrus.webx.WebxException;
import com.alibaba.citrus.webx.util.WebxUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;

public class TurbineRunDataImpl
implements TurbineRunDataInternal {
    private final RequestContext topRequestContext;
    private final LazyCommitRequestContext lazyCommitRequestContext;
    private final ParserRequestContext parserRequestContext;
    private final Map<String, PullService> pullServices;
    private final Map<String, Context> contexts;
    private final Navigator.Parameters forwardParameters = new ForwardParametersImpl();
    private final ModuleTraces moduleTraces = new ModuleTraces();
    private TargetTuple targetTuple = new TargetTuple();
    private TargetTuple redirectTargetTuple;
    private WebxComponent currentComponent;
    private boolean layoutEnabled;
    private String layoutTemplateOverride;
    private URIBroker redirectURI;

    public TurbineRunDataImpl(HttpServletRequest request) {
        this(request, null);
    }

    public TurbineRunDataImpl(HttpServletRequest request, Context context) {
        this.topRequestContext = Assert.assertNotNull(RequestContextUtil.getRequestContext(request), "no request context defined in request attributes", new Object[0]);
        this.lazyCommitRequestContext = RequestContextUtil.findRequestContext(this.topRequestContext, LazyCommitRequestContext.class);
        this.parserRequestContext = RequestContextUtil.findRequestContext(this.topRequestContext, ParserRequestContext.class);
        this.pullServices = CollectionUtil.createHashMap();
        this.contexts = CollectionUtil.createHashMap();
        if (context != null) {
            Context newContext = this.getContext();
            Set<String> keys = context instanceof PullableMappedContext ? ((PullableMappedContext)context).keySetWithoutPulling() : context.keySet();
            for (String key : keys) {
                newContext.put(key, context.get(key));
            }
        }
    }

    private String normalizeComponentName(String componentName) {
        WebxComponent currentComponent;
        if ((componentName = StringUtil.trimToNull(componentName)) != null && componentName.equals((currentComponent = this.getCurrentComponent()).getName())) {
            componentName = null;
        }
        return componentName;
    }

    private WebxComponent getCurrentComponent() {
        if (this.currentComponent == null) {
            this.currentComponent = WebxUtil.getCurrentComponent(this.getRequest());
        }
        return this.currentComponent;
    }

    private LazyCommitRequestContext getLazyCommitRequestContext() {
        return Assert.assertNotNull(this.lazyCommitRequestContext, "no lazyCommitRequestContext defined in request-contexts", new Object[0]);
    }

    private ParserRequestContext getParserRequestContext() {
        return Assert.assertNotNull(this.parserRequestContext, "no parserRequestContext defined in request-contexts", new Object[0]);
    }

    private PullService getPullService(String componentName) {
        if (!this.pullServices.containsKey(componentName = this.normalizeComponentName(componentName))) {
            PullService pullService;
            WebxComponent component = componentName == null ? this.getCurrentComponent() : Assert.assertNotNull(this.getCurrentComponent().getWebxComponents().getComponent(componentName), "could not find webx component: %s", componentName);
            WebApplicationContext context = component.getApplicationContext();
            try {
                pullService = (PullService)context.getBean("pullService", PullService.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                pullService = null;
            }
            this.pullServices.put(componentName, pullService);
        }
        return this.pullServices.get(componentName);
    }

    public RequestContext getRequestContext() {
        return this.topRequestContext;
    }

    public HttpServletRequest getRequest() {
        return this.topRequestContext.getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.topRequestContext.getResponse();
    }

    public ParameterParser getParameters() {
        return this.getParserRequestContext().getParameters();
    }

    public CookieParser getCookies() {
        return this.getParserRequestContext().getCookies();
    }

    public String getTarget() {
        return this.targetTuple.getTarget();
    }

    public void setTarget(String target) {
        this.targetTuple.setTarget(target);
    }

    public String getAction() {
        return this.targetTuple.getAction();
    }

    public void setAction(String action) {
        this.targetTuple.setAction(action);
    }

    public String getActionEvent() {
        return this.targetTuple.getActionEvent();
    }

    public void setActionEvent(String actionEvent) {
        this.targetTuple.setActionEvent(actionEvent);
    }

    public String getRedirectTarget() {
        return this.redirectTargetTuple == null ? null : this.redirectTargetTuple.getTarget();
    }

    public void setRedirectTarget(String redirectTarget) {
        this.setRedirectTargetAndAction(redirectTarget, null, null);
    }

    private void setRedirectTargetAndAction(String redirectTarget, String redirectAction, String redirectActionEvent) {
        redirectTarget = StringUtil.trimToNull(redirectTarget);
        if (!ObjectUtil.isEquals(this.getTarget(), redirectTarget)) {
            this.redirectTargetTuple = new TargetTuple().setTarget(redirectTarget).setAction(redirectAction).setActionEvent(redirectActionEvent);
        }
    }

    public boolean doRedirectTarget() {
        if (this.redirectTargetTuple != null) {
            this.targetTuple = this.redirectTargetTuple;
            this.redirectTargetTuple = null;
            ActionEventUtil.setEventName(this.getRequest(), this.getActionEvent());
            return true;
        }
        return false;
    }

    public String getRedirectLocation() {
        this.commitRedirectLocation();
        return this.getLazyCommitRequestContext().getRedirectLocation();
    }

    public void setRedirectLocation(String redirectLocation) {
        try {
            this.getResponse().sendRedirect(redirectLocation);
        }
        catch (IOException e) {
            throw new WebxException("Could not redirect to URI: " + redirectLocation, e);
        }
    }

    private void setRedirectLocation(URIBroker uri) {
        this.redirectURI = uri;
    }

    private void commitRedirectLocation() {
        if (this.redirectURI != null) {
            String uri = this.redirectURI.setURIType(URIBroker.URIType.full).render();
            this.redirectURI = null;
            this.setRedirectLocation(uri);
        }
    }

    public boolean isRedirected() {
        this.commitRedirectLocation();
        return this.redirectTargetTuple != null || this.getLazyCommitRequestContext().isRedirected();
    }

    public Context getContext() {
        return this.getContext(null);
    }

    public Context getContext(String componentName) {
        Context context = this.contexts.get(componentName = this.normalizeComponentName(componentName));
        if (context == null) {
            PullService pullService = this.getPullService(componentName);
            context = pullService != null ? new PullableMappedContext(pullService.getContext()) : new MappedContext();
            this.contexts.put(componentName, context);
        }
        return context;
    }

    public Context getCurrentContext() {
        if (this.moduleTraces.isEmpty()) {
            return null;
        }
        return ((ModuleTrace)this.moduleTraces.getLast()).getContext();
    }

    public void pushContext(Context context) {
        this.pushContext(context, null);
    }

    public void pushContext(Context context, String template) {
        this.moduleTraces.addLast(new ModuleTrace(context, template));
    }

    public Context popContext() throws IllegalStateException {
        Assert.assertTrue(!this.moduleTraces.isEmpty(), Assert.ExceptionType.ILLEGAL_STATE, "can't popContext without pushContext", new Object[0]);
        return ((ModuleTrace)this.moduleTraces.removeLast()).getContext();
    }

    public String getControlTemplate() {
        if (this.moduleTraces.isEmpty()) {
            return null;
        }
        return ((ModuleTrace)this.moduleTraces.getLast()).getTemplate();
    }

    public void setControlTemplate(String template) {
        Assert.assertTrue(!this.moduleTraces.isEmpty(), Assert.ExceptionType.ILLEGAL_STATE, "can't setControlTemplate without pushContext", new Object[0]);
        ((ModuleTrace)this.moduleTraces.getLast()).setTemplate(template);
    }

    public boolean isLayoutEnabled() {
        return this.layoutEnabled;
    }

    public void setLayoutEnabled(boolean enabled) {
        this.layoutEnabled = enabled;
    }

    public void setLayout(String layoutTemplate) {
        this.layoutTemplateOverride = StringUtil.trimToNull(layoutTemplate);
        if (this.layoutTemplateOverride != null) {
            this.setLayoutEnabled(true);
        }
    }

    public String getLayoutTemplateOverride() {
        return this.layoutTemplateOverride;
    }

    public Navigator.Parameters forwardTo(String target) {
        this.setRedirectTarget(target);
        return this.forwardParameters;
    }

    public Navigator.Parameters forwardTo(String target, String action, String actionEvent) {
        this.setRedirectTargetAndAction(target, action, actionEvent);
        return this.forwardParameters;
    }

    public Navigator.RedirectParameters redirectTo(String uriName) {
        uriName = Assert.assertNotNull(StringUtil.trimToNull(uriName), "no uriName", new Object[0]);
        URIBrokerService uris = (URIBrokerService)this.getCurrentComponent().getApplicationContext().getBean("uriBrokerService", URIBrokerService.class);
        URIBroker uri = Assert.assertNotNull(uris.getURIBroker(uriName), "could not find uri broker named \"%s\"", uriName);
        this.setRedirectLocation(uri);
        return new RedirectParametersImpl(uriName, uri);
    }

    public void redirectToLocation(String location) {
        this.setRedirectLocation(location);
    }

    private static class TargetTuple {
        private String target;
        private String action;
        private String actionEvent;

        private TargetTuple() {
        }

        public String getTarget() {
            return this.target;
        }

        public TargetTuple setTarget(String target) {
            this.target = StringUtil.trimToNull(target);
            return this;
        }

        public String getAction() {
            return this.action;
        }

        public TargetTuple setAction(String action) {
            this.action = StringUtil.trimToNull(action);
            return this;
        }

        public String getActionEvent() {
            return this.actionEvent;
        }

        public TargetTuple setActionEvent(String actionEvent) {
            this.actionEvent = StringUtil.trimToNull(actionEvent);
            return this;
        }

        public String toString() {
            return String.format("target=%s, action=%s, actionEvent=%s", this.target, this.action, this.actionEvent);
        }
    }

    private class ModuleTrace {
        private final Context context;
        private String template;

        public ModuleTrace(Context context, String template) {
            this.context = Assert.assertNotNull(context, "context", new Object[0]);
            this.template = template;
        }

        public Context getContext() {
            return this.context;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleTraces
    extends LinkedList<ModuleTrace> {
        private static final long serialVersionUID = 8167955929944105578L;

        private ModuleTraces() {
        }
    }

    private class RedirectParametersImpl
    implements Navigator.RedirectParameters {
        private final String uriName;
        private final URIBroker uri;

        public RedirectParametersImpl(String uriName, URIBroker uri) {
            this.uriName = uriName;
            this.uri = uri;
        }

        public Navigator.RedirectParameters withTarget(String target) {
            Assert.assertTrue(this.uri instanceof TurbineURIBroker, "URI is not a turbine-uri: %s", this.uriName);
            ((TurbineURIBroker)this.uri).setTarget(target);
            return this;
        }

        public Navigator.Parameters withParameter(String name, String ... values) {
            this.uri.setQueryData(name, values);
            return this;
        }

        public URIBroker uri() {
            return this.uri;
        }

        public void end() {
            TurbineRunDataImpl.this.commitRedirectLocation();
        }

        public String toString() {
            return "redirectTo(" + this.uri + ")";
        }
    }

    private class ForwardParametersImpl
    implements Navigator.Parameters {
        private ForwardParametersImpl() {
        }

        public Navigator.Parameters withParameter(String name, String ... values) {
            if (!ArrayUtil.isEmptyArray(values)) {
                TurbineRunDataImpl.this.getParameters().setStrings(name, values);
            }
            return this;
        }

        public void end() {
        }

        public String toString() {
            return "forwardTo(" + TurbineRunDataImpl.this.getRedirectTarget() + ") " + TurbineRunDataImpl.this.getParameters();
        }
    }
}

