/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.turbine.uribroker.uri.WebxURIBroker;

public class TurbineContentURIBroker
extends WebxURIBroker {
    protected static final int PREFIX_PATH_INDEX = 3;
    protected static final int CONTENT_PATH_INDEX = 4;
    private boolean hasPrefixPath;
    private boolean hasContentPath;

    public String getPrefixPath() {
        if (this.hasPrefixPath) {
            return this.getPathSegmentAsString(3);
        }
        return null;
    }

    public TurbineContentURIBroker setPrefixPath(String prefixPath) {
        this.setPathSegment(3, prefixPath);
        this.hasPrefixPath = true;
        return this;
    }

    public String getContentPath() {
        if (this.hasContentPath) {
            return this.getPathSegmentAsString(4);
        }
        return null;
    }

    public TurbineContentURIBroker setContentPath(String contentPath) {
        this.setPathSegment(4, contentPath);
        this.hasContentPath = true;
        return this;
    }

    public TurbineContentURIBroker getURI(String uri) {
        return this.setContentPath(this.setUriAndGetPath(uri));
    }

    protected URIBroker newInstance() {
        return new TurbineContentURIBroker();
    }

    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof TurbineContentURIBroker) {
            TurbineContentURIBroker parentContent = (TurbineContentURIBroker)parent;
            if (!this.hasPrefixPath) {
                this.hasPrefixPath = parentContent.hasPrefixPath;
                this.setPathSegment(3, parentContent.getPathSegment(3));
            }
            if (!this.hasContentPath) {
                this.hasContentPath = parentContent.hasContentPath;
                this.setPathSegment(4, parentContent.getPathSegment(4));
            }
        }
    }

    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof TurbineContentURIBroker) {
            TurbineContentURIBroker parentContent = (TurbineContentURIBroker)parent;
            this.hasPrefixPath = parentContent.hasPrefixPath;
            this.setPathSegment(3, parentContent.getPathSegment(3));
            this.hasContentPath = parentContent.hasContentPath;
            this.setPathSegment(4, parentContent.getPathSegment(4));
        }
    }

    protected int getPathSegmentCount() {
        return 5;
    }
}

