/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.uribroker.uri;

import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.turbine.uribroker.uri.WebxURIBroker;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;

public class TurbineURIBroker
extends WebxURIBroker {
    protected static final int TARGET_INDEX = 3;
    private static final boolean DEFAULT_CONVERT_TARGET_CASE = true;
    private static final String DEFAULT_TARGET_MAPPING_RULE = "extension.output";
    private static final String DEFAULT_ACTION_PARAM = "action";
    private MappingRuleService mappingRuleService;
    private boolean hasTarget;
    private String target;
    private Boolean convertTargetCase;
    private String targetMappingRule;
    private String actionParam;

    public MappingRuleService getMappingRuleService() {
        return this.mappingRuleService;
    }

    public void setMappingRuleService(MappingRuleService mappingRuleService) {
        this.mappingRuleService = mappingRuleService;
    }

    public String getTarget() {
        if (this.hasTarget) {
            return this.target;
        }
        return null;
    }

    public TurbineURIBroker setTarget(String target) {
        this.setPathSegment(3, this.convertTarget(target));
        this.hasTarget = true;
        this.target = StringUtil.trimToNull(target);
        return this;
    }

    private String convertTarget(String target) {
        if ((target = StringUtil.trimToNull(target)) != null) {
            if (this.getMappingRuleService() != null) {
                target = this.getMappingRuleService().getMappedName(this.getTargetMappingRule(), target);
            }
            if (!StringUtil.isEmpty(target) && this.isConvertTargetCase()) {
                int lastSlashIndex = target.lastIndexOf("/");
                target = lastSlashIndex >= 0 ? target.substring(0, lastSlashIndex) + "/" + StringUtil.toLowerCaseWithUnderscores(target.substring(lastSlashIndex + 1)) : StringUtil.toLowerCaseWithUnderscores(target);
            }
        }
        return target;
    }

    public String getTargetMappingRule() {
        return ObjectUtil.defaultIfNull(this.targetMappingRule, DEFAULT_TARGET_MAPPING_RULE);
    }

    public void setTargetMappingRule(String targetMappingRule) {
        this.targetMappingRule = StringUtil.trimToNull(targetMappingRule);
    }

    public boolean isConvertTargetCase() {
        return this.convertTargetCase == null ? true : this.convertTargetCase;
    }

    public TurbineURIBroker setConvertTargetCase(boolean convertTargetCase) {
        this.convertTargetCase = convertTargetCase;
        return this;
    }

    public String getActionParam() {
        return ObjectUtil.defaultIfNull(this.actionParam, DEFAULT_ACTION_PARAM);
    }

    public TurbineURIBroker setActionParam(String actionParam) {
        this.actionParam = StringUtil.trimToNull(actionParam);
        return this;
    }

    public String getAction() {
        return this.getQueryData(this.getActionParam());
    }

    public TurbineURIBroker setAction(String action) {
        this.setQueryData(this.getActionParam(), StringUtil.trimToNull(action));
        return this;
    }

    protected TurbineURIBroker newInstance() {
        return new TurbineURIBroker();
    }

    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof TurbineURIBroker) {
            TurbineURIBroker parentTurbine = (TurbineURIBroker)parent;
            if (this.mappingRuleService == null) {
                this.mappingRuleService = parentTurbine.mappingRuleService;
            }
            if (this.convertTargetCase == null) {
                this.convertTargetCase = parentTurbine.convertTargetCase;
            }
            if (this.targetMappingRule == null) {
                this.targetMappingRule = parentTurbine.targetMappingRule;
            }
            if (this.actionParam == null) {
                this.actionParam = parentTurbine.actionParam;
            }
            if (!this.hasTarget && parentTurbine.hasTarget) {
                this.setTarget(parentTurbine.target);
            }
            if (parentTurbine.getAction() != null) {
                this.getQuery().remove(parentTurbine.getActionParam());
                if (this.getAction() == null) {
                    this.setAction(parentTurbine.getAction());
                }
            }
        }
    }

    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof TurbineURIBroker) {
            TurbineURIBroker parentTurbine = (TurbineURIBroker)parent;
            this.mappingRuleService = parentTurbine.mappingRuleService;
            this.convertTargetCase = parentTurbine.convertTargetCase;
            this.targetMappingRule = parentTurbine.targetMappingRule;
            this.actionParam = parentTurbine.actionParam;
            if (this.hasTarget) {
                this.target = null;
                this.clearPathSegment(3);
            }
            if (parentTurbine.hasTarget) {
                this.setTarget(parentTurbine.target);
            }
            if (this.getAction() != null) {
                this.removeQueryData(this.getActionParam());
            }
            if (parentTurbine.getAction() != null) {
                this.setAction(parentTurbine.getAction());
            }
        }
    }

    protected int getPathSegmentCount() {
        return 4;
    }
}

