/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.internal.DynamicClassBuilder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InterfaceMaker;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFunctionDelegatorBuilder
extends DynamicClassBuilder {
    private final Map<Signature, Method> methods = CollectionUtil.createHashMap();
    private Class<?> mixinInterface;
    private Enhancer generator;

    public StaticFunctionDelegatorBuilder() {
    }

    public StaticFunctionDelegatorBuilder(ClassLoader cl) {
        super(cl);
    }

    public StaticFunctionDelegatorBuilder addClass(Class<?> utilClass) {
        for (Method method : utilClass.getMethods()) {
            if (!this.isPublicStatic(method)) continue;
            this.addMethod(method);
        }
        return this;
    }

    public StaticFunctionDelegatorBuilder addMethod(Method method) {
        return this.addMethod(method, null);
    }

    public StaticFunctionDelegatorBuilder addMethod(Method method, String rename) {
        Assert.assertNotNull(method, "Method is null", new Object[0]);
        Assert.assertTrue(this.isPublicStatic(method), "Method is not public static: %s", method);
        Signature sig = this.getSignature(method, rename);
        if (this.methods.containsKey(sig)) {
            throw new IllegalArgumentException("Duplicated method signature: " + sig + "\n  method: " + this.methods.get(sig));
        }
        this.methods.put(sig, method);
        return this;
    }

    public Class<?> getMixinInterface() {
        if (this.mixinInterface == null) {
            InterfaceMaker im = new InterfaceMaker();
            for (Map.Entry<Signature, Method> entry : this.methods.entrySet()) {
                Signature sig = entry.getKey();
                Method method = entry.getValue();
                Type[] exceptionTypes = new Type[method.getExceptionTypes().length];
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    exceptionTypes[i] = Type.getType(method.getExceptionTypes()[i]);
                }
                im.add(sig, exceptionTypes);
            }
            im.setClassLoader(this.getClassLoader());
            im.setNamingPolicy((NamingPolicy)new DefaultNamingPolicy(){

                public String getClassName(String prefix, String source, Object key, Predicate names) {
                    return super.getClassName("", ClassUtil.getSimpleClassName(StaticFunctionDelegatorBuilder.class), key, names);
                }
            });
            this.mixinInterface = im.create();
        }
        return this.mixinInterface;
    }

    public Object toObject() {
        if (this.generator == null) {
            final Class<?> intfs = this.getMixinInterface();
            final Map<Method, FastMethod> methodMappings = this.getMethodMappings(intfs);
            this.generator = new Enhancer();
            this.generator.setClassLoader(this.getClassLoader());
            this.generator.setSuperclass(Object.class);
            this.generator.setInterfaces(new Class[]{intfs});
            this.generator.setCallbacks(new Callback[]{new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    return proxy.invokeSuper(obj, args);
                }
            }, new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true);
                    for (Map.Entry entry : methodMappings.entrySet()) {
                        mb.append(((Method)entry.getKey()).getName(), ClassUtil.getSimpleMethodSignature(((FastMethod)entry.getValue()).getJavaMethod(), false, true, true, false));
                    }
                    return new ToStringBuilder().append(intfs.getName()).append(mb).toString();
                }
            }, new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    FastMethod realMethod = (FastMethod)Assert.assertNotNull(methodMappings.get(method), "unknown method: %s", method);
                    return realMethod.invoke(null, args);
                }
            }});
            this.generator.setCallbackFilter(new CallbackFilter(){

                public int accept(Method method) {
                    if (StaticFunctionDelegatorBuilder.this.isEqualsMethod(method) || StaticFunctionDelegatorBuilder.this.isHashCodeMethod(method)) {
                        return 0;
                    }
                    if (StaticFunctionDelegatorBuilder.this.isToStringMethod(method)) {
                        return 1;
                    }
                    return 2;
                }
            });
        }
        Object obj = this.generator.create();
        this.log.debug("Generated mixin function delegator: {}", obj);
        return obj;
    }

    private Map<Method, FastMethod> getMethodMappings(Class<?> intfs) {
        HashMap<Method, FastMethod> methodMappings = CollectionUtil.createHashMap();
        for (Method method : intfs.getMethods()) {
            Signature sig = this.getSignature(method, null);
            Method realMethod = Assert.assertNotNull(this.methods.get(sig), "unknown method signature: %s", sig);
            FastClass fc = FastClass.create((ClassLoader)this.getClassLoader(), realMethod.getDeclaringClass());
            FastMethod fm = fc.getMethod(realMethod);
            methodMappings.put(method, fm);
        }
        return methodMappings;
    }
}

