/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal.webpagelite;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ServletUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class RequestContext {
    private final String baseURL;
    private final String resourceName;
    private PrintWriter writer;
    private OutputStream stream;

    public RequestContext(String baseURL, String resourceName) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        this.baseURL = baseURL;
        this.resourceName = resourceName;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final String getBaseURL() {
        return this.baseURL;
    }

    public final String getResourceURL(String resourceName) {
        return ServletUtil.normalizeURI(this.baseURL + resourceName);
    }

    public final PrintWriter getWriter() {
        return Assert.assertNotNull(this.writer, Assert.ExceptionType.ILLEGAL_STATE, "call getWriter(contentType) first", new Object[0]);
    }

    public final PrintWriter getWriter(String contentType) throws IOException {
        if (this.writer == null) {
            this.writer = this.doGetWriter(contentType);
        }
        return this.writer;
    }

    protected abstract PrintWriter doGetWriter(String var1) throws IOException;

    public final OutputStream getOutputStream() {
        return Assert.assertNotNull(this.stream, Assert.ExceptionType.ILLEGAL_STATE, "call getOutputStream(contentType) first", new Object[0]);
    }

    public final OutputStream getOutputStream(String contentType) throws IOException {
        if (this.stream == null) {
            this.stream = this.doGetOutputStream(contentType);
        }
        return this.stream;
    }

    protected abstract OutputStream doGetOutputStream(String var1) throws IOException;

    public abstract void resourceNotFound(String var1) throws IOException;

    public abstract void redirectTo(String var1) throws IOException;

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.resourceName);
    }
}

