/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal.webpagelite;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.internal.webpagelite.RequestContext;
import com.alibaba.citrus.util.internal.webpagelite.ServletRequestContext;
import com.alibaba.citrus.util.io.StreamUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.util.templatelite.TextWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestProcessor<RC extends RequestContext>
implements PageComponentRegistry {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final Map<String, String> contentTypes = CollectionUtil.createHashMap();
    private final Map<String, PageComponent> components = CollectionUtil.createTreeMap(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int lenDiff = s2.length() - s1.length();
            if (lenDiff != 0) {
                return lenDiff;
            }
            return s1.compareTo(s2);
        }
    });

    @Override
    public void register(String componentPath, PageComponent component) {
        Assert.assertNotNull(componentPath, "componentPath is null", new Object[0]);
        Assert.assertTrue(componentPath.length() == 0 || !componentPath.startsWith("/") && componentPath.endsWith("/"), "invalid componentPath: %s", componentPath);
        Assert.assertTrue(!this.components.containsKey(componentPath), "duplicated component: %s", componentPath);
        this.components.put(componentPath, component);
    }

    @Override
    public String[] getComponentPaths() {
        return this.components.keySet().toArray(new String[this.components.size()]);
    }

    @Override
    public <PC extends PageComponent> PC getComponent(String componentPath, Class<PC> componentClass) {
        componentPath = PageComponent.normalizeComponentPath(componentPath);
        PageComponent component = Assert.assertNotNull(this.components.get(componentPath), "Component not found: %s", componentPath);
        if (componentClass != null) {
            return (PC)((PageComponent)componentClass.cast(component));
        }
        PageComponent pc = component;
        return (PC)pc;
    }

    public final void processRequest(RC request) throws IOException {
        String indexPage;
        boolean template;
        String resourceName = ((RequestContext)request).getResourceName();
        URL tmpres = this.getRawResource(resourceName);
        if (tmpres == null) {
            tmpres = this.getRawResource(resourceName + ".tpl");
            template = true;
        } else {
            template = false;
        }
        URL resource = tmpres;
        if (resource != null && !resource.getPath().endsWith("/")) {
            this.checkLastModified(request, this.getLastModifiedOfResource(request, resource, template), new Runnable((RequestContext)request, resource, template){
                final /* synthetic */ RequestContext val$request;
                final /* synthetic */ URL val$resource;
                final /* synthetic */ boolean val$template;
                {
                    this.val$request = requestContext;
                    this.val$resource = uRL;
                    this.val$template = bl;
                }

                public void run() throws IOException {
                    if (RequestProcessor.this.beforeRenderingResource(this.val$request, this.val$resource, this.val$template)) {
                        RequestProcessor.this.renderResource(this.val$request, this.val$resource, this.val$template);
                    }
                }
            });
            return;
        }
        boolean found = this.resourceExists(resourceName);
        if (!found && !resourceName.endsWith("/") && this.resourceExists(indexPage = resourceName + "/")) {
            ((RequestContext)request).redirectTo(((RequestContext)request).getResourceURL(indexPage));
            return;
        }
        if (!found) {
            ((RequestContext)request).resourceNotFound(resourceName);
            return;
        }
        this.checkLastModified(request, this.getLastModifiedOfPage(request, resourceName), new Runnable((RequestContext)request, resourceName){
            final /* synthetic */ RequestContext val$request;
            final /* synthetic */ String val$resourceName;
            {
                this.val$request = requestContext;
                this.val$resourceName = string;
            }

            public void run() throws IOException {
                if (RequestProcessor.this.beforeRenderingPage(this.val$request, this.val$resourceName)) {
                    RequestProcessor.this.renderPage(this.val$request, this.val$resourceName);
                }
            }
        });
    }

    private void checkLastModified(RC request, long lastModified, Runnable runner) throws IOException {
        ServletRequestContext servletRequest = ServletRequestContext.getServletRequestContext(request);
        if (lastModified < 0L || servletRequest == null || !"get".equalsIgnoreCase(servletRequest.getRequest().getMethod())) {
            runner.run();
        } else {
            long ifModifiedSince = servletRequest.getRequest().getDateHeader("If-Modified-Since");
            if (ifModifiedSince < lastModified / 1000L * 1000L) {
                if (lastModified >= 0L) {
                    servletRequest.getResponse().setDateHeader("Last-Modified", lastModified);
                }
                runner.run();
            } else {
                servletRequest.getResponse().setStatus(304);
            }
        }
    }

    protected abstract boolean resourceExists(String var1);

    private URL getRawResource(String resourceName) {
        for (String componentPath : this.components.keySet()) {
            if (!resourceName.startsWith(componentPath)) continue;
            String componentResourceName = resourceName.substring(componentPath.length());
            URL resource = this.components.get(componentPath).getClass().getResource(componentResourceName);
            if (resource == null) {
                resource = this.getClass().getResource(componentResourceName);
            }
            return resource;
        }
        URL resource = null;
        HashSet visitedPackages = CollectionUtil.createHashSet();
        for (Class<?> processorClass = this.getClass(); processorClass != null && RequestProcessor.class.isAssignableFrom(processorClass); processorClass = processorClass.getSuperclass()) {
            String processorPackage = processorClass.getPackage().getName();
            if (visitedPackages.contains(processorPackage)) continue;
            visitedPackages.add(processorPackage);
            resource = processorClass.getResource(resourceName);
            if (resource != null) break;
        }
        return resource;
    }

    protected long getLastModifiedOfPage(RC request, String resourceName) throws IOException {
        return -1L;
    }

    protected long getLastModifiedOfResource(RC request, URL resource, boolean template) throws IOException {
        if (!template) {
            return resource.openConnection().getLastModified();
        }
        return -1L;
    }

    protected boolean beforeRenderingPage(RC request, String resourceName) throws IOException {
        return true;
    }

    protected boolean beforeRenderingResource(RC request, URL resource, boolean template) throws IOException {
        return true;
    }

    protected abstract void renderPage(RC var1, String var2) throws IOException;

    private void renderResource(final RC request, URL resource, boolean template) throws IOException {
        String resourceName = ((RequestContext)request).getResourceName();
        int extIndex = resourceName.indexOf(".", resourceName.lastIndexOf("/") + 1);
        String ext = extIndex > 0 ? resourceName.substring(extIndex + 1) : null;
        String contentType = ObjectUtil.defaultIfNull(contentTypes.get(ext), DEFAULT_CONTENT_TYPE);
        if (!template) {
            StreamUtil.io(resource.openStream(), ((RequestContext)request).getOutputStream(contentType), true, true);
        } else {
            Template tpl = new Template(resource);
            PrintWriter out = ((RequestContext)request).getWriter(contentType);
            tpl.accept(new TextWriter<PrintWriter>(out){

                public void visitUrl(String relativeUrl) {
                    ((PrintWriter)this.out()).print(request.getResourceURL(relativeUrl));
                }
            });
            out.flush();
        }
    }

    protected List<String> getComponentResources(String ext) {
        LinkedList<String> names = CollectionUtil.createLinkedList();
        if (!(ext = StringUtil.trimToEmpty(ext)).startsWith(".")) {
            ext = "." + ext;
        }
        for (PageComponent component : this.components.values()) {
            String name = component.getComponentName() + ext;
            if (component.getClass().getResource(name) == null) continue;
            names.add(component.getComponentPath() + name);
        }
        return names;
    }

    static {
        contentTypes.put("css", "text/css");
        contentTypes.put("js", "application/javascript");
        contentTypes.put("html", "text/html");
        contentTypes.put("htm", "text/html");
        contentTypes.put("xml", "text/xml");
        contentTypes.put("txt", "text/plain");
        contentTypes.put("gif", "image/gif");
        contentTypes.put("jpg", "image/jpeg");
        contentTypes.put("png", "image/png");
        contentTypes.put("ico", "image/x-icon");
    }

    private static interface Runnable {
        public void run() throws IOException;
    }
}

