/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.templatelite;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.util.templatelite.VisitorInvocationErrorHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextWriter<A extends Appendable>
implements VisitorInvocationErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private A out;

    public TextWriter() {
    }

    public TextWriter(A out) {
        this.setOut(out);
    }

    public final void visitText(String text) throws IOException {
        this.out().append(text);
    }

    public final A out() {
        return (A)((Appendable)Assert.assertNotNull(this.out, Assert.ExceptionType.ILLEGAL_STATE, "setOut() not called yet", new Object[0]));
    }

    public final void setOut(A out) {
        this.out = out;
    }

    @Override
    public void handleInvocationError(String desc, Throwable e) throws Exception {
        log.debug("Error rendering " + desc, e);
        e = ExceptionUtil.getRootCause(e);
        String msg = e.getClass().getSimpleName() + " - " + e.getMessage();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (!ArrayUtil.isEmptyArray(stackTrace)) {
            msg = msg + " - " + stackTrace[0];
        }
        this.out.append(msg);
    }
}

