/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.KeyValuesComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EnvironmentVariablesComponent
extends PageComponent {
    private static final Set<String> PATH_LIKE_KEYS = CollectionUtil.createHashSet("PATH", "CLASSPATH", "LD_LIBRARY_PATH", "MANPATH");
    private final KeyValuesComponent keyValuesComponent;

    public EnvironmentVariablesComponent(PageComponentRegistry registry, String componentPath, KeyValuesComponent keyValuesComponent) {
        super(registry, componentPath);
        this.keyValuesComponent = keyValuesComponent;
    }

    public void visitTemplate(RequestHandlerContext context) {
        this.getTemplate().accept(new EnvironmentVariablesVisitor(context));
    }

    private class EnvironmentVariablesVisitor
    extends AbstractVisitor {
        private final Map<String, String> env;

        public EnvironmentVariablesVisitor(RequestHandlerContext context) {
            super(context, EnvironmentVariablesComponent.this);
            this.env = System.getenv();
        }

        public void visitEnv() {
            TreeMap<String, String> keyValues = CollectionUtil.createTreeMap();
            String pathSep = System.getProperty("path.separator");
            for (String key : this.env.keySet()) {
                Object value = StringEscapeUtil.escapeJava(ObjectUtil.defaultIfNull(this.env.get(key), ""));
                if (PATH_LIKE_KEYS.contains(key)) {
                    value = CollectionUtil.createArrayList(StringUtil.split((String)value, pathSep));
                }
                keyValues.put(String.valueOf(key), (String)value);
            }
            EnvironmentVariablesComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }
    }
}

