/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.util;

import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.PathNameWildcardCompiler;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class RequestURIFilter {
    public static final String EXCLUDE_PREFIX = "!";
    private final String[] uris;
    private final boolean[] excludes;
    private final Pattern[] patterns;

    public RequestURIFilter(String uris) {
        LinkedList<String> names = CollectionUtil.createLinkedList();
        LinkedList excludes = CollectionUtil.createLinkedList();
        LinkedList<Pattern> patterns = CollectionUtil.createLinkedList();
        for (String uri : StringUtil.split(ObjectUtil.defaultIfNull(uris, ""), ", \r\n")) {
            if ((uri = StringUtil.trimToNull(uri)) == null) continue;
            String fullUri = uri;
            boolean exclude = uri.startsWith(EXCLUDE_PREFIX);
            if (exclude) {
                uri = StringUtil.trimToNull(uri.substring(EXCLUDE_PREFIX.length()));
            }
            if (uri == null) continue;
            names.add(fullUri);
            excludes.add(exclude);
            patterns.add(PathNameWildcardCompiler.compilePathName(uri));
        }
        if (!patterns.isEmpty()) {
            this.uris = names.toArray(new String[names.size()]);
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
            this.excludes = new boolean[excludes.size()];
            for (int i = 0; i < excludes.size(); ++i) {
                this.excludes[i] = (Boolean)excludes.get(i);
            }
        } else {
            this.uris = BasicConstant.EMPTY_STRING_ARRAY;
            this.excludes = BasicConstant.EMPTY_BOOLEAN_ARRAY;
            this.patterns = null;
        }
    }

    public boolean matches(String path) {
        if (this.patterns != null) {
            for (int i = this.patterns.length - 1; i >= 0; --i) {
                if (!this.patterns[i].matcher(path).find()) continue;
                return !this.excludes[i];
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder().append("FilterOf").append(this.uris).toString();
    }
}

