/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.WebxComponent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class WebxUtil {
    private static final String CURRENT_WEBX_COMPONENT_KEY = "webx.component";

    public static WebxComponent getCurrentComponent(HttpServletRequest request) {
        return Assert.assertNotNull((WebxComponent)request.getAttribute(CURRENT_WEBX_COMPONENT_KEY), "No WebxComponent bound in request.  Make sure WebxFrameworkFilter run or set WebxComponent explicitly by calling WebxUtil", new Object[0]);
    }

    public static void setCurrentComponent(HttpServletRequest request, WebxComponent component) {
        if (component == null) {
            request.removeAttribute(CURRENT_WEBX_COMPONENT_KEY);
        } else {
            request.setAttribute(CURRENT_WEBX_COMPONENT_KEY, (Object)component);
        }
    }

    public static String getWebxVersion() {
        Package pkg = WebxUtil.class.getPackage();
        String version = null;
        if (pkg != null) {
            version = StringUtil.trimToNull(pkg.getImplementationVersion());
        }
        if (version == null) {
            version = "Unknown Version";
        }
        return version;
    }

    public static String getServletApiVersion(ServletContext servletContext) {
        return servletContext.getMajorVersion() + "." + servletContext.getMinorVersion();
    }
}

