/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgresChatMemoryRepository
extends JdbcChatMemoryRepository {
    private static final String POSTGRES_QUERY_ADD = "INSERT INTO ai_chat_memory (conversation_id, content, type, timestamp) VALUES (?, ?, ?, ?)";
    private static final String POSTGRES_QUERY_GET = "SELECT content, type FROM ai_chat_memory WHERE conversation_id = ? ORDER BY timestamp";

    private PostgresChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static PostgresBuilder postgresBuilder() {
        return new PostgresBuilder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT table_name FROM information_schema.tables WHERE table_name = '%s'", tableName.toLowerCase());
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE %s (id BIGSERIAL PRIMARY KEY, conversation_id VARCHAR(256) NOT NULL, content TEXT NOT NULL, type VARCHAR(100) NOT NULL, timestamp TIMESTAMP NOT NULL, CONSTRAINT chk_message_type CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')))", tableName);
    }

    @Override
    protected String getAddSql() {
        return POSTGRES_QUERY_ADD;
    }

    @Override
    protected String getGetSql() {
        return POSTGRES_QUERY_GET;
    }

    public static class PostgresBuilder {
        private JdbcTemplate jdbcTemplate;

        public PostgresBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public PostgresChatMemoryRepository build() {
            return new PostgresChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

