/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.weather;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.weather.WeatherProperties;
import com.alibaba.cloud.ai.toolcalling.weather.WeatherService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@ConditionalOnClass(value={WeatherService.class})
@EnableConfigurationProperties(value={WeatherProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.weather", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WeatherAutoConfiguration {
    @Bean(name={"getWeatherService"})
    @ConditionalOnMissingBean
    @Description(value="Use api.weather to get weather information.")
    public WeatherService getWeatherService(WeatherProperties properties, JsonParseTool jsonParseTool) {
        return new WeatherService(WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(headers -> headers.add("key", properties.getApiKey())).build(), jsonParseTool);
    }
}

