/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpClientType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliCloudSdk {
    private static final Logger log = LoggerFactory.getLogger(AliCloudSdk.class);
    private DefaultAcsClient defaultAcsClient;

    public AliCloudSdk(AliCloudConfiguration aliCloudConfiguration, String regionId) {
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)regionId, (String)aliCloudConfiguration.getAccessKey(), (String)aliCloudConfiguration.getSecretKey());
        defaultProfile.getHttpClientConfig().setClientType(HttpClientType.Compatible);
        DefaultAcsClient defaultAcsClient = new DefaultAcsClient((IClientProfile)defaultProfile);
        defaultAcsClient.setAutoRetry(false);
        this.defaultAcsClient = defaultAcsClient;
    }

    public AliCloudSdk(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration) {
        this(aliCloudConfiguration, edasConfiguration.getRegionId());
    }

    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ClientException {
        return (T)this.defaultAcsClient.getAcsResponse(request);
    }

    static {
        try {
            DefaultProfile.addEndpoint((String)"cn-beijing", (String)"cn-beijing", (String)"Edas", (String)"edas.cn-beijing.aliyuncs.com");
            DefaultProfile.addEndpoint((String)"cn-qingdao", (String)"cn-qingdao", (String)"Edas", (String)"edas.cn-qingdao.aliyuncs.com");
            DefaultProfile.addEndpoint((String)"cn-shenzhen", (String)"cn-shenzhen", (String)"Edas", (String)"edas.cn-shenzhen.aliyuncs.com");
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Edas", (String)"edas.cn-hangzhou.aliyuncs.com");
            DefaultProfile.addEndpoint((String)"cn-shanghai", (String)"cn-shanghai", (String)"Edas", (String)"edas.cn-shanghai.aliyuncs.com");
            DefaultProfile.addEndpoint((String)"ap-southeast-1", (String)"ap-southeast-1", (String)"Edas", (String)"edas.ap-southeast-1.aliyuncs.com");
        }
        catch (ClientException e) {
            log.warn("Edas pop api init failed.", (Throwable)e);
        }
    }
}

