/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adbclient;

import com.alibaba.cloud.analyticdb.adbclient.AdbClientException;
import com.alibaba.cloud.analyticdb.adbclient.AdbClientThreadFactory;
import com.alibaba.cloud.analyticdb.adbclient.ColumnDataType;
import com.alibaba.cloud.analyticdb.adbclient.ColumnInfo;
import com.alibaba.cloud.analyticdb.adbclient.DatabaseConfig;
import com.alibaba.cloud.analyticdb.adbclient.Row;
import com.alibaba.cloud.analyticdb.adbclient.TableInfo;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.mysql.jdbc.Driver;
import com.mysql.jdbc.JDBC4PreparedStatement;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AdbClient {
    private DatabaseConfig databaseConfig;
    private DruidDataSource dataSource;
    private static Map<String, DruidDataSource> dataSourceMap = new ConcurrentHashMap<String, DruidDataSource>();
    private Map<String, TableInfo> tableInfo;
    private Map<String, Integer> partitionColumnIndex;
    private Map<String, Boolean> isAllColumn;
    private Map<String, Map<String, Pair<Integer, String>>> tableColumnsMetaData;
    private Map<String, Map<String, Pair<Integer, String>>> configColumnsMetaData;
    private Map<String, String> insertSqlPrefix = new HashMap<String, String>();
    private static final String INSERT_TEMPLATE = "insert into %s ( %s ) values ";
    private static final String INSERT_ALL_COLUMN_TEMPLATE = "insert into %s values ";
    private static final String INSERT_IGNORE_TEMPLATE = "insert ignore into %s ( %s ) values ";
    private static final String INSERT_IGNORE_ALL_COLUMN_TEMPLATE = "insert ignore into %s values ";
    private static final String COLUMN_QUOTE_CHARACTER = "`";
    private static final String ALL_COLUMN_CHARACTER = "*";
    private static final String SQL_SPLIT_CHARACTER = " ,  ";
    private static final int SQL_SPLIT_CHARACTER_LEN = 4;
    protected static final long DEFAULT_SQL_LENGTH_LIMIT = 32768L;
    private AtomicInteger exceptionCount = new AtomicInteger(0);
    private AtomicLong totalCount = new AtomicLong(0L);
    private long periodStartTime = 0L;
    private long periodTime = 60000L;
    private Map<String, Map<Integer, MutablePair<StringBuilder, Integer>>> partitionBatch = new HashMap<String, Map<Integer, MutablePair<StringBuilder, Integer>>>();
    private List<String> commitExceptionDataList = Collections.synchronizedList(new ArrayList());
    private MySQLSyntaxErrorException commitException = null;
    private final ExecutorService executorService;
    private LinkedBlockingQueue<StringBuilder> sqlQueue = new LinkedBlockingQueue();
    private Map<String, StringBuilder> batchBuffer;

    public AdbClient(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
        this.periodStartTime = System.currentTimeMillis();
        this.initDatasource();
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new AdbClientThreadFactory(String.format("%s", databaseConfig.getTable())));
        this.initInstance();
    }

    public AdbClient(DatabaseConfig databaseConfig, DruidDataSource dataSource) {
        this.dataSource = dataSource;
        this.databaseConfig = databaseConfig;
        this.periodStartTime = System.currentTimeMillis();
        this.initDatasource();
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new AdbClientThreadFactory(String.format("%s", databaseConfig.getTable())));
        this.initInstance();
    }

    private Boolean initInstance() {
        if (this.partitionBatch.size() > 0) {
            return false;
        }
        this.tableInfo = new HashMap<String, TableInfo>();
        this.partitionColumnIndex = new HashMap<String, Integer>();
        this.isAllColumn = new HashMap<String, Boolean>();
        this.configColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>();
        this.tableColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>();
        for (String tableName : this.databaseConfig.getTable()) {
            this.isAllColumn.put(tableName, false);
            this.partitionColumnIndex.put(tableName, -1);
        }
        if (!this.databaseConfig.isPartitionBatch()) {
            this.batchBuffer = new HashMap<String, StringBuilder>();
        }
        this.checkConfig();
        if (this.databaseConfig.getParallelNumber() <= 0) {
            this.databaseConfig.setParallelNumber(1);
        }
        this.logger("info", "init adb client successfully");
        return true;
    }

    private void initNewTable(String tableName) {
        try {
            this.getTableInfo(this.databaseConfig.getDatabase(), Collections.singletonList(tableName), (Connection)this.dataSource.getConnection());
        }
        catch (AdbClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AdbClientException(106, "Init new table error:" + e.getMessage(), null);
        }
        if (this.tableInfo.get(tableName) == null) {
            throw new AdbClientException(106, "The table " + tableName + " do not exist", null);
        }
        if (!this.databaseConfig.getTable().contains(tableName)) {
            this.databaseConfig.setColumns(tableName, Collections.singletonList(ALL_COLUMN_CHARACTER));
            this.databaseConfig.getTable().add(tableName);
        }
        this.partitionColumnIndex.put(tableName, -1);
        this.checkTableConfig(tableName);
    }

    public void addRow(String tableName, Row row) {
        if (this.tableInfo.get(tableName) == null) {
            throw new AdbClientException(106, "The table " + tableName + " do not exist", null);
        }
        if (row.getColumnValues().size() != this.databaseConfig.getColumns(tableName).size()) {
            throw new AdbClientException(103, "Add row data is illegal, column size is not equal as config", null);
        }
        DruidPooledConnection conn = null;
        Statement stmt = null;
        int retryTime = 0;
        while (retryTime <= this.databaseConfig.getRetryTimes()) {
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.createStatement();
                break;
            }
            catch (Exception e) {
                if (retryTime == this.databaseConfig.getRetryTimes()) {
                    this.logger("error", "addRow creating statement and connection failed after " + retryTime + " times retry: " + e.getMessage());
                    throw new AdbClientException(104, "Creating statement and connection failed after " + retryTime + " times retry: " + e.getMessage(), null);
                }
                ++retryTime;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.databaseConfig.getRetryIntervalTime());
                }
                catch (InterruptedException e2) {
                    this.logger("error", "commit error " + e2.getMessage());
                }
            }
        }
        StringBuilder sqlSb = null;
        int partitionId = 0;
        if (this.databaseConfig.isPartitionBatch()) {
            partitionId = this.getHashPartition(tableName, row);
            if (this.partitionBatch.get(tableName) == null) {
                this.partitionBatch.put(tableName, new HashMap());
            }
            if (this.partitionBatch.get(tableName).get(partitionId) == null) {
                this.partitionBatch.get(tableName).put(partitionId, (MutablePair<StringBuilder, Integer>)new MutablePair((Object)new StringBuilder(), (Object)0));
            }
            sqlSb = (StringBuilder)this.partitionBatch.get(tableName).get(partitionId).getLeft();
        } else {
            if (this.batchBuffer.get(tableName) == null) {
                this.batchBuffer.put(tableName, new StringBuilder());
            }
            sqlSb = this.batchBuffer.get(tableName);
        }
        try {
            int l;
            String sqlResult = this.generateInsertSql(tableName, (Connection)conn, row);
            String subSql = sqlResult.substring(this.insertSqlPrefix.get(tableName).length());
            int subSqlLen = subSql.getBytes().length;
            if (sqlSb.length() > 0 && (long)((l = (Integer)this.partitionBatch.get(tableName).get(partitionId).getRight() + subSqlLen) + 4) >= this.databaseConfig.getCommitSize()) {
                try {
                    if (this.commitExceptionDataList.size() > 0 || this.commitException != null) {
                        this.commitExceptionDataList.clear();
                        this.commitException = null;
                    }
                    if (this.databaseConfig.isPartitionBatch()) {
                        this.executeBatchSql(sqlSb);
                        if (this.partitionBatch.get(tableName) == null) {
                            this.partitionBatch.put(tableName, new HashMap());
                        }
                        this.partitionBatch.get(tableName).put(partitionId, (MutablePair<StringBuilder, Integer>)new MutablePair((Object)new StringBuilder(), (Object)0));
                        sqlSb = (StringBuilder)this.partitionBatch.get(tableName).get(partitionId).getLeft();
                    } else {
                        this.executeBatchSql(sqlSb);
                        sqlSb = new StringBuilder();
                        this.batchBuffer.put(tableName, sqlSb);
                    }
                    if (this.commitExceptionDataList.size() > 0) {
                        this.logger("error", "Auto commit error data list " + this.commitExceptionDataList.toString());
                        throw new AdbClientException(101, this.commitExceptionDataList, (Throwable)this.commitException);
                    }
                }
                catch (AdbClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AdbClientException(100, "Sql length is too large, auto commit failed. Please commit first. exception:" + e.getMessage(), null);
                }
            }
            if (sqlSb.length() == 0) {
                sqlSb.append(sqlResult.replace(SQL_SPLIT_CHARACTER, " , "));
                subSqlLen += this.insertSqlPrefix.get(tableName).getBytes().length;
            } else {
                sqlSb.append(SQL_SPLIT_CHARACTER);
                sqlSb.append(subSql.replace(SQL_SPLIT_CHARACTER, " , "));
                subSqlLen += 4;
            }
            this.partitionBatch.get(tableName).get(partitionId).setRight((Object)((Integer)this.partitionBatch.get(tableName).get(partitionId).getRight() + subSqlLen));
            this.totalCount.incrementAndGet();
        }
        catch (AdbClientException e) {
            this.logger("error", "addRow " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            throw new AdbClientException(103, String.format("Add row data (%s) error: %s", row.getColumnValues().toString(), e.getMessage()), null);
        }
        finally {
            this.closeDBResources(null, stmt, (Connection)conn);
        }
    }

    public void addMap(String table, Map<String, String> oriMap) {
        String tableName = table.toLowerCase();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : oriMap.entrySet()) {
            dataMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        if (this.tableInfo.get(tableName) == null) {
            throw new AdbClientException(106, "The table " + tableName + " do not exist", null);
        }
        Row row = this.mapToRow(tableName, dataMap);
        this.addRow(tableName, row);
    }

    public void addRows(String tableName, List<Row> rows) {
        for (Row row : rows) {
            this.addRow(tableName, row);
        }
    }

    public void addMaps(String tableName, List<Map<String, String>> maps) {
        for (Map<String, String> map : maps) {
            this.addMap(tableName, map);
        }
    }

    public void addStrictMap(String table, Map<String, String> oriMap) {
        String tableName = table.toLowerCase();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : oriMap.entrySet()) {
            dataMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        if (this.tableInfo.get(tableName) == null) {
            this.initNewTable(tableName);
            if (this.tableInfo.get(tableName) == null) {
                throw new AdbClientException(103, "The table " + table + " do not exist", null);
            }
        }
        Row row = this.mapToRow(tableName, dataMap);
        if (dataMap.size() > 0) {
            if (!this.isAllColumn.get(tableName).booleanValue()) {
                throw new AdbClientException(103, "The column " + dataMap.keySet().toString() + " of table " + tableName + " do not exist", null);
            }
            dataMap.clear();
            this.initNewTable(tableName);
            for (Map.Entry<String, String> entry : oriMap.entrySet()) {
                dataMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            row = this.mapToRow(tableName, dataMap);
            if (dataMap.size() > 0) {
                throw new AdbClientException(103, "The columns " + dataMap.keySet().toString() + " of table " + tableName + " do not exist", null);
            }
            this.commitSingleTable(tableName);
        }
        this.addRow(tableName, row);
    }

    public void addStrictMaps(String tableName, List<Map<String, String>> maps) {
        for (Map<String, String> map : maps) {
            this.addStrictMap(tableName, map);
        }
    }

    public void commit() {
        try {
            if (this.commitExceptionDataList.size() > 0 || this.commitException != null) {
                this.commitExceptionDataList.clear();
                this.commitException = null;
            }
            if (this.databaseConfig.isPartitionBatch()) {
                for (Map<Integer, MutablePair<StringBuilder, Integer>> partitionString : this.partitionBatch.values()) {
                    for (Map.Entry<Integer, MutablePair<StringBuilder, Integer>> entry : partitionString.entrySet()) {
                        this.sqlQueue.put((StringBuilder)entry.getValue().getLeft());
                    }
                }
            } else {
                for (Map.Entry<String, StringBuilder> entry : this.batchBuffer.entrySet()) {
                    this.sqlQueue.put(entry.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger("error", e.getMessage());
            throw new AdbClientException(102, e.getMessage() + e.getCause().toString(), null);
        }
        this.sqlQueueExecute();
    }

    private void commitSingleTable(String table) {
        if (this.partitionBatch.get(table) == null || this.partitionBatch.get(table).size() == 0) {
            return;
        }
        try {
            if (this.commitExceptionDataList.size() > 0 || this.commitException != null) {
                this.commitExceptionDataList.clear();
                this.commitException = null;
            }
            if (this.databaseConfig.isPartitionBatch()) {
                for (Map.Entry<Integer, MutablePair<StringBuilder, Integer>> entry : this.partitionBatch.get(table).entrySet()) {
                    this.sqlQueue.put((StringBuilder)entry.getValue().getLeft());
                }
            } else {
                for (Map.Entry<String, StringBuilder> entry : this.batchBuffer.entrySet()) {
                    this.sqlQueue.put(entry.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger("error", e.getMessage());
            throw new AdbClientException(102, e.getMessage() + e.getCause().toString(), null);
        }
        this.sqlQueueExecute();
    }

    private void sqlQueueExecute() {
        ArrayList futureList = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(this.databaseConfig.getParallelNumber());
        for (int i = 0; i < this.databaseConfig.getParallelNumber(); ++i) {
            Future<?> future = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        StringBuilder sb;
                        while ((sb = (StringBuilder)AdbClient.this.sqlQueue.poll()) != null) {
                            AdbClient.this.executeBatchSql(sb);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            futureList.add(future);
        }
        try {
            latch.await();
            for (Future future : futureList) {
                future.get();
            }
            if (this.databaseConfig.isPartitionBatch()) {
                this.partitionBatch.clear();
            } else {
                this.batchBuffer.clear();
            }
            if (System.currentTimeMillis() - this.periodStartTime > this.periodTime) {
                this.periodStartTime = System.currentTimeMillis();
                this.logger("info", "Total record count " + this.totalCount);
            }
        }
        catch (AdbClientException e) {
            this.logger("error", "commit " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger("error", "commit " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        if (this.commitExceptionDataList.size() > 0) {
            this.logger("error", "commit error data list " + this.commitExceptionDataList.toString());
            throw new AdbClientException(101, this.commitExceptionDataList, (Throwable)this.commitException);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void stop() {
        if (this.databaseConfig.isPartitionBatch() ? this.partitionBatch.size() > 0 || this.sqlQueue.size() > 0 : this.batchBuffer.size() > 0) {
            throw new AdbClientException(107, "Batch data do not commit, please commit first", null);
        }
        this.executorService.shutdown();
        this.databaseConfig = null;
        this.batchBuffer = null;
        this.partitionBatch = null;
        this.dataSource = null;
        this.tableInfo.clear();
        this.tableColumnsMetaData.clear();
        this.configColumnsMetaData.clear();
    }

    public TableInfo getTableInfo(String tableName) {
        return this.tableInfo.get(tableName);
    }

    public List<ColumnInfo> getColumnInfo(String tableName) {
        return this.tableInfo.get(tableName).getColumns();
    }

    private void initDatasource() {
        if (this.dataSource != null) {
            DruidPooledConnection testConn = null;
            try {
                testConn = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new AdbClientException(104, "Creating statement and connection failed: " + e.getMessage(), null);
            }
            finally {
                this.closeDBResources(null, null, (Connection)testConn);
            }
            return;
        }
        if (this.databaseConfig.isShareDataSource() && dataSourceMap.get(this.databaseConfig.getDatabase()) != null) {
            this.dataSource = dataSourceMap.get(this.databaseConfig.getDatabase());
            return;
        }
        this.dataSource = new DruidDataSource();
        this.dataSource.setDriverClassName(Driver.class.getName());
        this.dataSource.setUsername(this.databaseConfig.getUser());
        this.dataSource.setPassword(this.databaseConfig.getPassword());
        this.dataSource.setUrl("jdbc:mysql://" + this.databaseConfig.getHost() + ":" + this.databaseConfig.getPort() + "/" + this.databaseConfig.getDatabase());
        this.dataSource.setInitialSize(4);
        this.dataSource.setMaxActive(512);
        this.dataSource.setPoolPreparedStatements(false);
        this.dataSource.setValidationQuery("show status like '%Service_Status%'");
        this.dataSource.setValidationQueryTimeout(1000);
        this.dataSource.setMinIdle(4);
        this.dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        this.dataSource.setTestWhileIdle(true);
        this.dataSource.setTestOnBorrow(false);
        this.dataSource.setTestOnReturn(false);
        this.dataSource.setKeepAlive(true);
        this.dataSource.setPhyMaxUseCount(100000L);
        if (this.databaseConfig.isShareDataSource()) {
            dataSourceMap.put(this.databaseConfig.getDatabase(), this.dataSource);
        }
    }

    private Boolean checkConfig() {
        try {
            this.checkDatabaseConfig();
            this.getTableInfo(this.databaseConfig.getDatabase(), this.databaseConfig.getTable(), (Connection)this.dataSource.getConnection());
            for (String tableName : this.databaseConfig.getTable()) {
                this.checkTableConfig(tableName);
            }
            return true;
        }
        catch (Exception e) {
            throw new AdbClientException(106, "Check config exception: " + e.getMessage(), null);
        }
    }

    private void dealColumnConf(String tableName, List<String> tableColumns) {
        List<String> userConfiguredColumns = this.databaseConfig.getColumns(tableName);
        if (null == userConfiguredColumns || userConfiguredColumns.isEmpty()) {
            throw new AdbClientException(106, "Config is error. Do not have column list", null);
        }
        if (1 == userConfiguredColumns.size() && ALL_COLUMN_CHARACTER.equals(userConfiguredColumns.get(0))) {
            this.isAllColumn.put(tableName, true);
            this.databaseConfig.setColumns(tableName, tableColumns);
        } else {
            if (userConfiguredColumns.size() > tableColumns.size()) {
                throw new AdbClientException(106, String.format("Database config is error. The count of writer columns %s is bigger than the count of read table's columns {}.", userConfiguredColumns.size(), tableColumns.size()), null);
            }
            AdbClient.makeSureNoValueDuplicate(userConfiguredColumns, false);
            ArrayList<String> removeQuotedColumns = new ArrayList<String>();
            for (String each : userConfiguredColumns) {
                if (each.startsWith(COLUMN_QUOTE_CHARACTER) && each.endsWith(COLUMN_QUOTE_CHARACTER)) {
                    removeQuotedColumns.add(each.substring(1, each.length() - 1));
                    continue;
                }
                removeQuotedColumns.add(each);
            }
            AdbClient.makeSureBInA(tableColumns, removeQuotedColumns, false);
        }
    }

    private String generateInsertSql(String tableName, Connection connection, Row record) throws SQLException {
        String sql = null;
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append(this.insertSqlPrefix.get(tableName));
        sqlSb.append("(");
        int columnsSize = this.databaseConfig.getColumns(tableName).size();
        for (int i = 0; i < columnsSize; ++i) {
            if (i + 1 != columnsSize) {
                sqlSb.append("?,");
                continue;
            }
            sqlSb.append("?");
        }
        sqlSb.append(")");
        PreparedStatement statement = connection.prepareStatement(sqlSb.toString());
        for (int i = 0; i < this.databaseConfig.getColumns(tableName).size(); ++i) {
            String columnName = this.databaseConfig.getColumns(tableName).get(i);
            int columnSqltype = (Integer)this.configColumnsMetaData.get(tableName).get(columnName).getLeft();
            if (record.getColumnValues().get(i) == null) {
                if (this.tableInfo.get(tableName).getColumns().get(i).getDefaultValue() != null) {
                    this.prepareColumnTypeValue(statement, columnSqltype, this.tableInfo.get(tableName).getColumns().get(i).getDefaultValue(), i, columnName, tableName);
                    continue;
                }
                this.prepareColumnTypeValue(statement, columnSqltype, null, i, columnName, tableName);
                continue;
            }
            this.prepareColumnTypeValue(statement, columnSqltype, record.getColumnValues().get(i).toString(), i, columnName, tableName);
        }
        sql = ((JDBC4PreparedStatement)((DruidPooledPreparedStatement)statement).getRawPreparedStatement()).asSql();
        this.closeDBResources(null, statement, null);
        return sql;
    }

    private void getTableInfo(String schema, List<String> tables, Connection connection) {
        if (tables == null) {
            throw new RuntimeException("tables is not exist");
        }
        StringBuilder tablesSb = new StringBuilder();
        int i = 1;
        for (String table : tables) {
            tablesSb.append("'").append(table).append("'");
            if (i < tables.size()) {
                tablesSb.append(",");
            }
            ++i;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            String columnMetaSql = String.format("select ordinal_position,column_name,data_type,type_name,column_comment, is_nullable, column_default, table_name from information_schema.columns where table_schema = '%s' and table_name in ( %s ) order by ordinal_position", schema.toLowerCase(), tablesSb.toString());
            rs = statement.executeQuery(columnMetaSql);
            HashMap columnInfoListMap = new HashMap();
            while (rs.next()) {
                if (columnInfoListMap.get(rs.getString(8)) == null) {
                    columnInfoListMap.put(rs.getString(8), new ArrayList());
                }
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setOrdinal(rs.getInt(1));
                columnInfo.setName(rs.getString(2));
                columnInfo.setDataType(ColumnDataType.getTypeByName(rs.getString(4).toUpperCase()));
                columnInfo.setComment(rs.getString(5));
                columnInfo.setNullable("YES".equals(rs.getString(6)));
                columnInfo.setDefaultValue(rs.getString(7));
                ((List)columnInfoListMap.get(rs.getString(8))).add(columnInfo);
            }
            for (String table : tables) {
                if (columnInfoListMap.get(table) != null && !((List)columnInfoListMap.get(table)).isEmpty()) continue;
                this.logger("error", "Table" + table + " is not existed or do not has any column");
            }
            this.closeDBResources(rs, statement, null);
            String tableMetaSql = String.format("select update_type, partition_type, partition_column, partition_count, primary_key_columns, sub_partition_column, table_name from information_schema.tables where table_schema = '%s' and table_name in ( %s )", schema.toLowerCase(), tablesSb.toString());
            statement = connection.createStatement();
            rs = statement.executeQuery(tableMetaSql);
            while (rs.next()) {
                String t = rs.getString(7);
                TableInfo tableInfoTmp = new TableInfo();
                tableInfoTmp.setColumns((List)columnInfoListMap.get(t));
                tableInfoTmp.setTableSchema(schema);
                tableInfoTmp.setTableName(t);
                tableInfoTmp.setUpdateType(rs.getString(1));
                tableInfoTmp.setPartitionType(rs.getString(2));
                tableInfoTmp.setPartitionColumn(rs.getString(3));
                tableInfoTmp.setPartitionCount(rs.getInt(4));
                String primaryKeyColumns = rs.getString(5);
                if (StringUtils.isNotBlank((CharSequence)primaryKeyColumns)) {
                    tableInfoTmp.setPrimaryKeyColumns(Arrays.asList(StringUtils.split((String)primaryKeyColumns, (String)",")));
                } else {
                    tableInfoTmp.setPrimaryKeyColumns(null);
                }
                tableInfoTmp.setSubPartitionColumn(rs.getString(6));
                this.tableInfo.put(t, tableInfoTmp);
            }
            this.closeDBResources(rs, statement, null);
            for (String table : tables) {
                if (this.tableInfo.get(table) != null) continue;
                this.logger("error", "Table" + table + " is not existed or do not has any column");
            }
            this.closeDBResources(rs, statement, connection);
        }
        catch (Exception e) {
            try {
                throw new AdbClientException(106, "GetTableInfo exception: " + e.getMessage(), null);
            }
            catch (Throwable throwable) {
                this.closeDBResources(rs, statement, connection);
                throw throwable;
            }
        }
    }

    private void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new AdbClientException(105, "Close ResultSet occur SQLException " + e.getMessage(), null);
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new AdbClientException(105, "Close Statement occur SQLException " + e.getMessage(), null);
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new AdbClientException(105, "Close Connection occur SQLException " + e.getMessage(), null);
            }
        }
    }

    private Map<String, Pair<Integer, String>> getColumnMetaData(TableInfo tableInfo, List<String> userColumns) {
        HashMap<String, Pair<Integer, String>> columnMetaData = new HashMap<String, Pair<Integer, String>>();
        List<ColumnInfo> columnInfoList = tableInfo.getColumns();
        for (String column : userColumns) {
            if (column.startsWith(COLUMN_QUOTE_CHARACTER) && column.endsWith(COLUMN_QUOTE_CHARACTER)) {
                column = column.substring(1, column.length() - 1);
            }
            for (ColumnInfo columnInfo : columnInfoList) {
                if (!column.equalsIgnoreCase(columnInfo.getName())) continue;
                ImmutablePair eachPair = new ImmutablePair((Object)columnInfo.getDataType().sqlType, (Object)columnInfo.getDataType().name);
                columnMetaData.put(columnInfo.getName(), (Pair<Integer, String>)eachPair);
            }
        }
        return columnMetaData;
    }

    private void prepareColumnTypeValue(PreparedStatement statement, int columnSqltype, String column, int preparedPatamIndex, String columnName, String tableName) throws SQLException {
        switch (columnSqltype) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                statement.setString(preparedPatamIndex + 1, column);
                break;
            }
            case -5: 
            case 4: 
            case 5: 
            case 7: {
                if (this.databaseConfig.getEmptyAsNull().booleanValue() && "".equals(column) || column == null) {
                    statement.setNull(preparedPatamIndex + 1, -5);
                    break;
                }
                statement.setLong(preparedPatamIndex + 1, Long.parseLong(column));
                break;
            }
            case 2: 
            case 3: {
                if (this.databaseConfig.getEmptyAsNull().booleanValue() && "".equals(column) || column == null) {
                    statement.setNull(preparedPatamIndex + 1, 3);
                    break;
                }
                statement.setBigDecimal(preparedPatamIndex + 1, new BigDecimal(column));
                break;
            }
            case 6: 
            case 8: {
                if (this.databaseConfig.getEmptyAsNull().booleanValue() && "".equals(column) || column == null) {
                    statement.setNull(preparedPatamIndex + 1, 8);
                    break;
                }
                statement.setDouble(preparedPatamIndex + 1, Double.parseDouble(column));
                break;
            }
            case -6: {
                if (null == column) {
                    statement.setNull(preparedPatamIndex + 1, -5);
                    break;
                }
                statement.setLong(preparedPatamIndex + 1, Long.valueOf(column));
                break;
            }
            case 91: {
                java.util.Date utilDate;
                Date sqlDate = null;
                try {
                    utilDate = column == null || "".equals(column) ? null : new SimpleDateFormat("yyyy-MM-dd").parse(column);
                }
                catch (Exception e) {
                    if (e instanceof ParseException) {
                        try {
                            java.util.Date utilDate2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(column);
                        }
                        catch (Exception ex) {
                            throw new SQLException(String.format("Date transform error\uff1a[%s]", column));
                        }
                    }
                    throw new SQLException(String.format("Date transform error\uff1a[%s]", column));
                }
                if (null != utilDate) {
                    sqlDate = new Date(utilDate.getTime());
                }
                statement.setDate(preparedPatamIndex + 1, sqlDate);
                break;
            }
            case 92: {
                java.util.Date utilDate;
                Time sqlTime = null;
                try {
                    utilDate = column == null || "".equals(column) ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(column);
                }
                catch (Exception e) {
                    throw new SQLException(String.format("TIME transform error\uff1a[%s]", column));
                }
                if (null != utilDate) {
                    sqlTime = new Time(utilDate.getTime());
                }
                statement.setTime(preparedPatamIndex + 1, sqlTime);
                break;
            }
            case 93: {
                java.util.Date utilDate;
                Timestamp sqlTimestamp = null;
                try {
                    utilDate = column == null || "".equals(column) ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(column);
                }
                catch (Exception e) {
                    throw new SQLException(String.format("TIMESTAMP transform error\uff1a[%s]", column));
                }
                if (null != utilDate) {
                    sqlTimestamp = new Timestamp(utilDate.getTime());
                }
                statement.setTimestamp(preparedPatamIndex + 1, sqlTimestamp);
                break;
            }
            case 16: {
                if (null == column) {
                    statement.setNull(preparedPatamIndex + 1, 16);
                    break;
                }
                statement.setBoolean(preparedPatamIndex + 1, Boolean.parseBoolean(column));
                break;
            }
            default: {
                Pair<Integer, String> columnMetaPair = this.configColumnsMetaData.get(tableName).get(columnName);
                throw new AdbClientException(106, String.format("Your config is illegal. Because ADB does not support this type: column:[%s], type:[%s], Java type:[%s].", columnName, columnMetaPair.getRight(), columnMetaPair.getLeft()), null);
            }
        }
    }

    private static void makeSureNoValueDuplicate(List<String> aList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        if (1 == aList.size()) {
            return;
        }
        List<String> list = null;
        list = !caseSensitive ? AdbClient.valueToLowerCase(aList) : new ArrayList<String>(aList);
        Collections.sort(list);
        int len = list.size() - 1;
        for (int i = 0; i < len; ++i) {
            if (!list.get(i).equals(list.get(i + 1))) continue;
            throw new RuntimeException(String.format("The column %s in config must be uniq", list.get(i)));
        }
    }

    private static List<String> valueToLowerCase(List<String> aList) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        ArrayList<String> result = new ArrayList<String>(aList.size());
        for (String oneValue : aList) {
            result.add(null != oneValue ? oneValue.toLowerCase() : null);
        }
        return result;
    }

    private static void makeSureBInA(List<String> aList, List<String> bList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty() || null == bList || bList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        List<String> all = null;
        List<String> part = null;
        if (!caseSensitive) {
            all = AdbClient.valueToLowerCase(aList);
            part = AdbClient.valueToLowerCase(bList);
        } else {
            all = new ArrayList<String>(aList);
            part = new ArrayList<String>(bList);
        }
        for (String oneValue : part) {
            if (all.contains(oneValue)) continue;
            throw new RuntimeException(String.format("The column %s is not exist in table", oneValue));
        }
    }

    private int getHashPartition(String tableName, Row row) {
        String value = null;
        if (this.partitionColumnIndex.get(tableName) != null && this.partitionColumnIndex.get(tableName) != -1 && row.getColumnValues().get(this.partitionColumnIndex.get(tableName)) != null) {
            value = row.getColumnValues().get(this.partitionColumnIndex.get(tableName)).toString();
        }
        if (value == null) {
            for (String pk : this.tableInfo.get(tableName).getPrimaryKeyColumns()) {
                if (this.tableInfo.get(tableName).getSubPartitionColumn() != null && pk.equals(this.tableInfo.get(tableName).getSubPartitionColumn())) continue;
                int subPartitionIndex = this.databaseConfig.getColumns(tableName).indexOf(pk);
                if (row.getColumnValues().get(subPartitionIndex) == null) continue;
                value = row.getColumnValues().get(subPartitionIndex).toString();
                break;
            }
            if (value == null) {
                return new Random().nextInt(this.tableInfo.get(tableName).getPartitionCount());
            }
        }
        long crc32 = AdbClient.getCRC32(value);
        return (int)(crc32 % (long)this.tableInfo.get(tableName).getPartitionCount());
    }

    private static long getCRC32(String value) {
        CRC32 checksum = new CRC32();
        byte[] bytes = value.getBytes();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    private void checkDatabaseConfig() {
        if (this.databaseConfig.getTable() == null || this.databaseConfig.getTable().size() == 0) {
            throw new RuntimeException("Table can not be null");
        }
        for (String tableName : this.databaseConfig.getTable()) {
            if (this.databaseConfig.getColumns(tableName) != null) continue;
            throw new RuntimeException(String.format("Columns of table %s can not be null", tableName));
        }
        if (this.databaseConfig.getHost() == null) {
            throw new RuntimeException("Host can not be null");
        }
        if (this.databaseConfig.getDatabase() == null) {
            throw new RuntimeException("Database can not be null");
        }
        if (this.databaseConfig.getPassword() == null) {
            throw new RuntimeException("Password can not be null");
        }
        if (this.databaseConfig.getUser() == null) {
            throw new RuntimeException("Username can not be null");
        }
        if (this.databaseConfig.getPort() == 0) {
            throw new RuntimeException("Port can not be 0");
        }
        if (this.databaseConfig.getEmptyAsNull() == null) {
            throw new RuntimeException("EmptyAsNull can not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchSql(StringBuilder sb) {
        if (sb.length() != 0) {
            int retryNum = 0;
            DruidPooledConnection conn = null;
            Statement stmt = null;
            while (retryNum <= this.databaseConfig.getRetryTimes()) {
                try {
                    conn = this.dataSource.getConnection();
                    stmt = conn.createStatement();
                    stmt.execute(sb.toString());
                    break;
                }
                catch (MySQLSyntaxErrorException e) {
                    if (this.databaseConfig.isInsertExceptionSplit()) {
                        this.commitException = e;
                        this.executeEachRow(sb);
                        break;
                    }
                }
                catch (SQLException e) {
                    if (retryNum == this.databaseConfig.getRetryTimes()) {
                        throw new AdbClientException(102, String.format("Commit failed after %s times retry, please commit again later! Detail of exception is %s", retryNum, e.getMessage()), null);
                    }
                }
                finally {
                    this.closeDBResources(null, stmt, (Connection)conn);
                }
                ++retryNum;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.databaseConfig.getRetryIntervalTime());
                }
                catch (InterruptedException e) {
                    this.logger("error", "commit error " + e.getMessage());
                }
            }
        }
    }

    private void executeEachRow(StringBuilder sb) {
        Statement stmt = null;
        DruidPooledConnection conn = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
        }
        catch (SQLException ec) {
            throw new AdbClientException(104, "Creating statement and connection failed when commit: " + ec.getMessage(), null);
        }
        Map<String, String[]> splitSqlMap = this.splitBatchSql(sb);
        for (Map.Entry<String, String[]> entry : splitSqlMap.entrySet()) {
            for (String splitSql : entry.getValue()) {
                try {
                    stmt.execute(this.insertSqlPrefix.get(entry.getKey()) + splitSql);
                }
                catch (Exception ex) {
                    this.closeDBResources(null, stmt, (Connection)conn);
                    try {
                        conn = this.dataSource.getConnection();
                        stmt = conn.createStatement();
                    }
                    catch (SQLException ec) {
                        throw new AdbClientException(104, "Creating statement and connection failed when commit: " + ec.getMessage(), null);
                    }
                    if (!this.databaseConfig.isIgnoreInsertError()) {
                        this.commitExceptionDataList.add(splitSql);
                        continue;
                    }
                    this.exceptionCount.incrementAndGet();
                }
            }
        }
        this.closeDBResources(null, stmt, (Connection)conn);
    }

    private Map<String, String[]> splitBatchSql(StringBuilder sb) {
        String tableName = null;
        tableName = this.databaseConfig.isInsertIgnore() ? sb.toString().split(" ")[3] : sb.toString().split(" ")[2];
        StringBuilder dataBuffer = sb.replace(0, this.insertSqlPrefix.get(tableName).length(), "");
        HashMap<String, String[]> resMap = new HashMap<String, String[]>();
        resMap.put(tableName, dataBuffer.toString().split(SQL_SPLIT_CHARACTER));
        return resMap;
    }

    private void logger(String level, String msg) {
        if (this.databaseConfig.getLogger() != null) {
            if ("info".equals(level)) {
                this.databaseConfig.getLogger().info("Adb Client info: {}", (Object)msg);
            } else if ("error".equals(level)) {
                this.databaseConfig.getLogger().error("Adb Client error: {}", (Object)msg);
            }
        }
    }

    private void checkTableConfig(String tableName) {
        TableInfo tableInfoTmp = this.tableInfo.get(tableName);
        if (tableInfoTmp == null) {
            return;
        }
        if (!"realtime".equals(tableInfoTmp.getUpdateType().toLowerCase())) {
            throw new RuntimeException("table " + tableName + " is not realtime table, can not insert by Adb Client");
        }
        ArrayList<String> allColumns = new ArrayList<String>();
        List<ColumnInfo> columnInfo = tableInfoTmp.getColumns();
        for (ColumnInfo eachColumn : columnInfo) {
            allColumns.add(eachColumn.getName());
        }
        this.dealColumnConf(tableName, allColumns);
        this.tableColumnsMetaData.put(tableName, this.getColumnMetaData(tableInfoTmp, this.databaseConfig.getColumns(tableName)));
        HashMap<String, Pair<Integer, String>> configColumnMetaDataTmp = new HashMap<String, Pair<Integer, String>>();
        for (int i = 0; i < this.databaseConfig.getColumns(tableName).size(); ++i) {
            String oriEachColumn = this.databaseConfig.getColumns(tableName).get(i);
            String eachColumn = oriEachColumn;
            if (eachColumn.startsWith(COLUMN_QUOTE_CHARACTER) && eachColumn.endsWith(COLUMN_QUOTE_CHARACTER)) {
                eachColumn = eachColumn.substring(1, eachColumn.length() - 1);
            }
            for (String eachAdsColumn : tableInfoTmp.getColumnsNames()) {
                if (!eachColumn.equalsIgnoreCase(eachAdsColumn)) continue;
                configColumnMetaDataTmp.put(oriEachColumn, this.tableColumnsMetaData.get(tableName).get(eachAdsColumn));
            }
            if (!eachColumn.equalsIgnoreCase(tableInfoTmp.getPartitionColumn())) continue;
            this.partitionColumnIndex.put(tableName, i);
        }
        this.configColumnsMetaData.put(tableName, configColumnMetaDataTmp);
        if (this.isAllColumn.get(tableName).booleanValue()) {
            if (!this.databaseConfig.isInsertWithColumnName()) {
                if (this.databaseConfig.isInsertIgnore()) {
                    this.insertSqlPrefix.put(tableName, String.format(INSERT_IGNORE_ALL_COLUMN_TEMPLATE, tableName));
                } else {
                    this.insertSqlPrefix.put(tableName, String.format(INSERT_ALL_COLUMN_TEMPLATE, tableName));
                }
            } else if (this.databaseConfig.isInsertIgnore()) {
                this.insertSqlPrefix.put(tableName, String.format(INSERT_IGNORE_TEMPLATE, tableName, StringUtils.join(this.databaseConfig.getColumns(tableName), (String)",")));
            } else {
                this.insertSqlPrefix.put(tableName, String.format(INSERT_TEMPLATE, tableName, StringUtils.join(this.databaseConfig.getColumns(tableName), (String)",")));
            }
        } else if (this.databaseConfig.isInsertIgnore()) {
            this.insertSqlPrefix.put(tableName, String.format(INSERT_IGNORE_TEMPLATE, tableName, StringUtils.join(this.databaseConfig.getColumns(tableName), (String)",")));
        } else {
            this.insertSqlPrefix.put(tableName, String.format(INSERT_TEMPLATE, tableName, StringUtils.join(this.databaseConfig.getColumns(tableName), (String)",")));
        }
    }

    private Row mapToRow(String tableName, Map<String, String> dataMap) {
        Row row = new Row();
        int i = 0;
        for (ColumnInfo ci : this.tableInfo.get(tableName).getColumns()) {
            if (!this.isAllColumn.get(tableName).booleanValue()) {
                i = this.databaseConfig.getColumns(tableName).indexOf(ci.getName());
            }
            if (dataMap.get(ci.getName()) != null) {
                row.setColumn(i, dataMap.get(ci.getName()));
                dataMap.remove(ci.getName());
            } else {
                if (!ci.isNullable()) {
                    throw new AdbClientException(106, String.format("The column %s of table %s can not be null", ci.getName(), tableName), null);
                }
                row.setColumn(i, ci.getDefaultValue());
            }
            if (!this.isAllColumn.get(tableName).booleanValue()) continue;
            ++i;
        }
        return row;
    }
}

