/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure;

import com.alibaba.cloud.dubbo.autoconfigure.DubboServiceRegistrationAutoConfiguration;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreRegisteredEvent;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.zookeeper.serviceregistry.ServiceInstanceRegistration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnNotWebApplication
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DubboServiceRegistrationAutoConfiguration.class})
@Aspect
public class DubboServiceRegistrationNonWebApplicationAutoConfiguration {
    private static final String REST_PROTOCOL = "rest";
    @Autowired
    private ServiceRegistry serviceRegistry;
    @Autowired
    private Registration registration;
    private volatile Integer serverPort = null;
    private volatile boolean registered = false;
    @Autowired
    private DubboServiceMetadataRepository repository;

    @Around(value="execution(* org.springframework.cloud.client.serviceregistry.Registration.getPort())")
    public Object getPort(ProceedingJoinPoint pjp) throws Throwable {
        return this.serverPort != null ? this.serverPort : pjp.proceed();
    }

    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationStarted() {
        this.setServerPort();
        this.register();
    }

    private void register() {
        if (this.registered) {
            return;
        }
        this.serviceRegistry.register(this.registration);
        this.registered = true;
    }

    private void setServerPort() {
        if (this.serverPort == null) {
            for (List<URL> urls : this.repository.getAllExportedUrls().values()) {
                urls.stream().filter(url -> REST_PROTOCOL.equalsIgnoreCase(url.getProtocol())).findFirst().ifPresent(url -> {
                    this.serverPort = url.getPort();
                });
                if (this.serverPort != null) continue;
                urls.stream().findAny().ifPresent(url -> {
                    this.serverPort = url.getPort();
                });
            }
        }
    }

    @Configuration
    @ConditionalOnBean(name={"org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration"})
    class ConsulConfiguration {
        ConsulConfiguration() {
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            Registration registration = event.getSource();
            ConsulAutoRegistration consulRegistration = (ConsulAutoRegistration)registration;
            this.setPort(consulRegistration);
        }

        private void setPort(ConsulAutoRegistration consulRegistration) {
            int port = consulRegistration.getPort();
            NewService newService = consulRegistration.getService();
            if (newService.getPort() == null) {
                newService.setPort(Integer.valueOf(port));
            }
        }
    }

    @Configuration
    @ConditionalOnBean(name={"org.springframework.cloud.zookeeper.serviceregistry.ZookeeperAutoServiceRegistrationAutoConfiguration"})
    class ZookeeperConfiguration
    implements SmartInitializingSingleton {
        @Autowired
        private ServiceInstanceRegistration registration;

        ZookeeperConfiguration() {
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            this.registration.setPort(DubboServiceRegistrationNonWebApplicationAutoConfiguration.this.serverPort.intValue());
        }

        public void afterSingletonsInstantiated() {
            this.registration.getServiceInstance();
        }
    }
}

