/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import io.seata.core.context.RootContext;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SeataFeignBlockingLoadBalancerClient
implements Client {
    private static final Log LOG = LogFactory.getLog(SeataFeignBlockingLoadBalancerClient.class);
    private final Client delegate;
    private final BlockingLoadBalancerClient loadBalancerClient;

    SeataFeignBlockingLoadBalancerClient(Client delegate, BlockingLoadBalancerClient loadBalancerClient) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        URI originalUri = URI.create(request.url());
        String serviceId = originalUri.getHost();
        Assert.state((serviceId != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        ServiceInstance instance = this.loadBalancerClient.choose(serviceId);
        if (instance == null) {
            String message = "Load balancer does not contain an instance for the service " + serviceId;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            return Response.builder().request(request).status(HttpStatus.SERVICE_UNAVAILABLE.value()).body(message, StandardCharsets.UTF_8).build();
        }
        String reconstructedUrl = this.loadBalancerClient.reconstructURI(instance, originalUri).toString();
        Request newRequest = Request.create((Request.HttpMethod)request.httpMethod(), (String)reconstructedUrl, this.enrichRequstHeader(request.headers()), (Request.Body)request.requestBody());
        return this.delegate.execute(newRequest, options);
    }

    private Map<String, Collection<String>> enrichRequstHeader(Map<String, Collection<String>> headers) {
        String xid = RootContext.getXID();
        if (!StringUtils.isEmpty((Object)xid)) {
            HashMap<String, Collection<String>> newHeaders = new HashMap<String, Collection<String>>();
            newHeaders.putAll(headers);
            newHeaders.put("TX_XID", Arrays.asList(xid));
            return newHeaders;
        }
        return headers;
    }
}

