/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import java.util.Arrays;
import java.util.Optional;

public enum RuleType {
    FLOW("flow", FlowRule.class),
    DEGRADE("degrade", DegradeRule.class),
    PARAM_FLOW("param-flow", ParamFlowRule.class),
    SYSTEM("system", SystemRule.class),
    AUTHORITY("authority", AuthorityRule.class),
    GW_FLOW("gw-flow", "com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule"),
    GW_API_GROUP("gw-api-group", "com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition");

    private final String name;
    private Class clazz;
    private String clazzName;

    private RuleType(String name, Class clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    private RuleType(String name, String clazzName) {
        this.name = name;
        this.clazzName = clazzName;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazz() {
        if (this.clazz != null) {
            return this.clazz;
        }
        try {
            return Class.forName(this.clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<RuleType> getByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        return Arrays.stream(RuleType.values()).filter(ruleType -> name.equals(ruleType.getName())).findFirst();
    }

    public static Optional<RuleType> getByClass(Class clazz) {
        return Arrays.stream(RuleType.values()).filter(ruleType -> clazz == ruleType.getClazz()).findFirst();
    }
}

